function [mdel,mw1,p0,sigp1,c0] = NMR_correlation(xC,xH,xO,xvol)
    % This function calculates the structural NMR parameters for coal as an
    % input into the CPD model. This is based on the correlations by
    % Genetti.
    
    % The inputs are from the proximate and ultimate analysis of each coal.
    % THESE VALUES MUST BE ON A DRY, ASH-FREE (DAF) BASIS.
    
    % xC is the daf mass fraction of carbon
    % xH is the daf mass fraction of hydrogen
    % xN is the daf mass fraction of nitrogen
    % xO is the daf mass fraction of oxygen
    % xvol is the daf ASTM volatile matter content
    
    % correlation parameters
    
    nmr_param = [421.957, 1301.41, 0.489809, -52.1054;
        -8.64692, 16.3879, -0.00981566, 1.63872;
        0.0463894, -0.187493, 0.000133046, -0.0107548;
        -8.47272, -454.773, 0.155483, -1.23688;
        1.18173, 51.7109, -0.0243873, 0.0931937;
        1.15366, -10.072, 0.00705248, -0.165673;
        -0.0434024, 0.0760827, 0.000219163, 0.00409556;
        0.556772, 1.36022, -0.0110498, 0.00926097;
        -0.00654575, -0.0313561, 0.000100939, -8.26717e-5];
    
    % calculate NMR structural parameters based on input and correlation
    % parameters
    param = zeros(4,1);
    for i=1:4
        param(i) = nmr_param(1,i)+nmr_param(2,i)*xC+nmr_param(3,i)*xC^2+...
            nmr_param(4,i)*xH+nmr_param(5,i)*xH^2+nmr_param(6,i)*xO+...
            nmr_param(7,i)*xO^2+nmr_param(8,i)*xvol+nmr_param(9,i)*xvol^2;
    end
    mdel = param(1);
    mw1 = param(2);
    p0 = param(3);
    sigp1 = param(4);
    c0 = min(0.36,max((0.118*xC-10.1),0))+min(0.15,max((0.014*xO-0.175),0));

end