%this script drives the cpd heat model
%last updated 12/2/2014 by Troy Holland, BYU
clear;
close all;
clc;

% Proximate and ultimate analysis on a DAF basis
fixed_carbon = 54.71; % on a percent basis
volatile_matter = 45.29; % on a percent basis
xC = 75.57; % carbon mass fraction
xH = 5.32; % hydrogen mass fraction
xN = 1.14; % nitrogen mass fraction
xS = 0.64; % sulfur mass fraction
xO = 17.34; % oxygen mass fraction

% Use this NMR_correlation file if you do not have the measured NMR
% parameters. This file comprises the Genetti correlations to predict NMR
% parameters based on proximate and ultimate analyses.
% NOTE: if not using the Genetti correlations, comment the following line
% out of this driver file.
[mdel,mw1,p0,sigp1,c0] = NMR_correlation(xC,xH,xO,volatile_matter);


% NMR Structural Parameters
% NOTE:  Use the following variable declarations to input the NMR
% parameters directly. Use this if you already have the measured or
% predicted NMR parameters. If using the NMR_correlation file, comment the
% following lines out of the driver program.
% p0=0.613;%		!p0		
% c0=0.113;%		!c0
% sigp1=5.01;%	!sig+1
% mw1=352.6;%		!mw
% mdel=42.2;%		!mdel (7 will be subtracted internally to the CPD model)

%Enter the heating rate in K/s. You will likely only want to change "heating0",
%though you are free to change other values if you like.

heating0=1e5;%(K/s)
Tf0=1800;%K
hold0=0;%s

heating1=0;
Tf1=1800;
hold1=10;


% Pressure (in atmospheres)
% default value is set to 1 atmosphere, but can be changed using the
% following variable assignment.
press = 1;  % atm


%Input the kinetic parameters. The parameter n is simply a multiplier that
%allows you to change all the values at once by a factor. I suspect you
%won't need it, so it should be left at a value of 1, but it was convenient
%for me.
% NOTE:  These values should not be changed unless you are using the CPD
% model for biomass or other fuels.

n=1;

ab=2.6e15*n;%	!ab
eb0=55400*n;%		!eb
ebsig=1800*n;% 		!ebsig
ac=0.9*n;%		!ac=rho
ec0=0*n;%		!ec0
ag=3.e15*n;%		!ag
eg0=60000*n;%		!eg
egsig=8100*n;%     	!egsig
acr=3.e15*n;%		!Acr (pre-exponential factor for crosslinking rate)
ecr=65000*n;%		!Ecr (Activation energy for crosslinking rate)
an=9e17*n;%		!an (Pre-exponential factor for HCN release)
en0=100000*n;%		!en (Activation energy for HCN release)
ensig=17000*n;%		!ensig (deviation bound for dist en for HCN release)


%Build the input matrix. Note that there are additional inputs that
%shouldn't need to be changed in most cases.

Input_matrix=[p0,c0,sigp1,mw1,mdel,heating0,Tf0,hold0,heating1,Tf1,hold1,...
              ab,eb0,ebsig,ac,ec0,ag,eg0,egsig,acr,ecr,an,en0,ensig,press,...
              xC,xH,xO,xN,xS];


output=cpdheat(Input_matrix);

tar=output(:,1);%unitless fraction
total_volatiles=output(:,2);%unitless fraction
time=output(:,3);%seconds
temperature=output(:,4);%Kelvin
light_gas=output(:,5);%unitless fraction
% Divide the outputs
% Tar and Gas Release:
time = output(:,1);         % seconds
temperature = output(:,2);  % Kelvin
fcross = output(:,3);       % unitless mass fraction of cross-linking
labile = output(:,4);       % Fraction of labile bridges
ftar = output(:,5);         % Tar yield
fgas = output(:,6);         % Light gas yield
fchar = output(:,7);        % Char yield
ftot = output(:,8);         % Total volatiles yield (ftar+fgas)
fmet = output(:,9);         % Fraction of metaplast

% CPD model parameters:
l = output(:,10);
c = output(:,11);
del2 = output(:,12);
g12 = output(:,13);
g22 = output(:,14);
gtot = output(:,15);
p = output(:,16);

% Nitrogen release:
mw = output(:,17);
Nca = output(:,18);
Nclus = output(:,19);
fnchar = output(:,20);      % fraction of nitrogen remaining in char
fntar = output(:,21);       % fraction of nitrogen in the tar
fnhcn = output(:,22);       % fraction of nitrogen in HCN
fntot = output(:,23);       % total nitrogen fraction

% Light gas distribution:
fh2o = output(:,24);        % fraction of total mass release as H2O
fco2 = output(:,25);        % fraction of total mass release as CO2
fch4 = output(:,26);        % fraction of total mass release as CH4
fco = output(:,27);         % fraction of total mass release as CO
fother = output(:,28);      % fraction of total mass release as other hydrocarbons
yh2o = output(:,29);        % fraction of light gas as H2O
yco2 = output(:,30);        % fraction of light gas as CO2
ych4 = output(:,31);        % fraction of light gas as CH4
yco = output(:,32);         % fraction of light gas as CO
yother = output(:,33);      % fraction of light gas as other hydrocarbons
Xgas = output(:,34);        % CPD indicator of the fraction of total light gas that has been released
