C	THIS IS M.W.BECKSTEAD'S VERSION OF THE EDWARDS THERMOCHEMICAL PROGRAM
C
C
      COMMON/AZ/A(260,11),    IEVP(11),     NAMX2(260),   RTOTO,
     1          ANS(23),      IHEAD1(6),    NCHNG,        SCH,
     2          ATMOS,        IHEAD2(6),                  SPI,
     3          ATW,          IMBALA,       NCON,         SR(260),
     4          B(11),        INTIAL,       NCONV,        TANS(23),
     5          BMIN,         INTAPE,       NCTXP,        TANS1(23),
     6          CBAR,         ION,          NDET,         TANS2(23),
     7          CSTAR,        IOUTP,        NEQ,          TC,
     8          D,            ITE(6),       NGIN,         TIMES,
     9          DELPI,        ITER,         NKIN,         TO
      COMMON/BZ/DELPO,        ITT,          NKINC,        TOL,
     1          DELTO,        JLINED,       NLEL,         TOLMAX,
     2          DELXY,        K2,           NM,           TOLT,
     3          EL(23,24),    K3,           NMP,          U(260),
     4          ENTRPY,       LB,           NN,           Y(260),
     5          GAMACT,       LIBTP,        NN1,          YBAR,
     6          H(260),       LITER,        NNN,          YBC,
     7          HBAR,         LKDROP,       NP,           YC(260),
     8          HC,           LOUT,         NPRNT1,       YOUT(260,6),
     9          HI,           LV,           NSIN,         YR(260)
      COMMON/CZ/HR(260),      MAJOR,        NSYS,         Z(260,10),
     1          IDKIN(20),    MINOR,        NT,
     2          IDKINC(20),   MPD,          OUT(20,6),    IPART,
     3          IDSIN(260),   MPDP,         PC,
     4          IEV(11),      NAMX1(260),   R,            IEVN(11)
      COMMON/EZ/ NPN,             RLOT,  ZBAR,        ATWT(55),  WTG,
     1             CTRPT,GMFOUT(260,6)
      COMMON/LBT/ LIBTP2
      COMMON/BZZ/ IREP, HIK, NENT, PSIC(10), ATMOSC, NEPS
      COMMON/DATINT/KDATE(3)
      DIMENSION  NAME(11),    GATOMS(4),    LABEL1(10),   Q(10),
     1           MELM(55),    HPROP(10),    LABEL2(10),   QE(10,55),
     2                        ICOL(10),     MONTH(12),    QEI(11),
     3           COI(9),      IDPROP(9),    NAM1(10),     QMOL(9),
     4           DENS(10),    IDU(9),       NAM2(10),     QMOLWT(10),
     5           EC(9),       IMDENS(2),    NAME1(10),    SPIM(9),
     6           ECMAX(9),    IROW(10),     NAME2(10),    TABOUT(10),
     7           ECMIN(9),    ITT1(4),      PCT(10),      TU(10),
     8           ET(9,9),     KCON1(58),                  VOL(9),
     9           ECONST(9),   KU(9),        PSIX(20),     QMASS(9,40)
      DIMENSION ISAY(13),     TG(20),       EPS(10),      TFROZN(20)
      EQUIVALENCE (QMASS(1,2),ET(1,1)),     (QMASS(1,11),COI(1)),
     1            (QMASS(1,12),EC(1)),      (QMASS(1,13),ECMAX(1)),
     2            (QMASS(1,14),ECMIN(1)),   (QMASS(1,15),ECONST(1)),
     3            (QMASS(1,16),IDU(1)),     (QMASS(1,17),KU(1)),
     4            (QMASS(1,18),SPIM(1))
      DIMENSION NAMEM(260,4),QEM(260,4),KCHARG(260),IMPT(260)
      EQUIVALENCE (A(1,1),NAMEM(1,1)),(A(1,5),QEM(1,1)),
     1(YC(1),KCHARG(1)),(Y(1),IMPT(1))
      CHARACTER*5 GATOMS
C
C               INITIALIZE THE PROGRAM.
C
      LOGICAL FLAG,TABTP,SOP,DVE,AAG
      DATA NAST/'*   '/
      DATA NOPTN/58/
      DATA (KCON1(I), I=1,53)/
     1            3HLIB,3HSEL,3HCHP,3HEXP,3HWTS,3HMOL,3HVOL,3HMOD,3HNMO,
     13HXEQ,3HEPS,3HNEP,3HTEM,3HNTE,3HTAB,3HELM,3HNEL,3HOPT,3HDET,3HNDE,
     1            3HTHR,3HNTH,3HION,3HNIO,3HPAN,3HNPA,3HOUT,3HNOV,3HMIN,
     13HNMI,3HITR,3HMOP,3HVOP,3HSOP,3HSTO,3HRED,3HNTA,3HEND,3H   ,3HNSO,
     13HDVE, 3HAAG, 3HNAA,               3HPCC, 3HNPC, 3HSAY, 3HNEX,
     13HFRZ, 3HNFR, 3HENT, 3HNEN,        3HPRN, 3HHEL       /
      DATA (GATOMS(I),I=1,4)/'GRAM ', 'ATOMS', '/100 ', 'GRAMS' /
      DATA(MONTH(I),I=1,12)/3HJAN,3HFEB,3HMAR,3HAPR,3HMAY,3HJUN,3HJUL,3H
     1AUG,3HSEP,3HOCT,3HNOV,3HDEC/
      DATA(ITT1(I),I=1,4)/2H  ,1H*,1H$,2H$*/
      DATA (IMDENS(I), I=1,2)/
     1   ' DEN', 'SITY'  /
C
      DO 1 J=1,11
    1 IEVP(J)=0
C
C               KDATE USED ONLY IN +MAIN+.
C               SEE MAP SUBROUTINE +DATES+.
C
      CALL INTDAT
      KDATE(3)=2000+KDATE(3)
      AAG=.FALSE.
      DVE=.FALSE.
      SOP=.FALSE.
      TABTP=.FALSE.
      LIBTP = 21
      LIBTP2 = 4
      INTAPE = 2
      IOUTP = 3
      ISTORE=9
      OPEN (UNIT=LIBTP, FILE='EDCONV.DAT',
     X       FORM = 'UNFORMATTED',TYPE='OLD')
      REWIND LIBTP
      IWHAT=0
      IIFILE=0
      JFILE=1
      KFILE=0
      LFILE=0
      NFILE=0
      MANY=0
      NDF=0
      NDET=0
      R=1.98726
      READ (LIBTP) NLEL
      DO 5 I=1,NLEL
C    5 READ (LIBTP) MELM(I),ATWT(I)
         READ (LIBTP) MELM(I),ATWT(I)
5     CONTINUE
      NLEL1=NLEL+1
      NPRNT1=0
      ION=0
      IONPRE=0
      NNN=0
      NENT = 0
      MINOR=0
      IPART=0
      CTRPT = 0.000050
      DELPO=0.01
      DELTO=0.01
      DELXY=0.0001
      DELPI=0.001
      NKIN=0
      NCHP=1
      PSIC(1)=1000.0
      TG(1)=0.0
      NEXP=0
      NPROP=9
      NEPS=0
      NTEMP = 1
      ITEMP = 0
      NCHNG=260
      NMP=0
      IFROZN=0
      LOUT=0
      ICALDA=1
      LITER=50
      TYPE 5000
5000  FORMAT('0WELCOME TO THE EDWARDS THERMO EQUILIBRIUM',
     1' PROGRAM', /, ' WE WILL TRY TO MAKE THE INPUT SIMPLE',/,
     1' INSTRUCTIONS WILL INDICATE WHAT SHOULD BE INCLUDED',/,
     2' FIRST, PLEASE SPECIFY WHETHER THE OUTPUT IS TO',/,
     4' GO TO THE PRINTER OR TO THE SCREEN',/,' ENTER 1 FOR PRINTER'
     5,' OR 0 FOR SCREEN:  ', 1X, $)
      ACCEPT 5010, II
      IF( II .EQ. 0) IOUTP = 5
5010  FORMAT(I)
      TYPE 5020
5020  FORMAT(///,' THANKS..WE CAN NOW PROCEED WITH THE INPUT DATA',/
     1' EACH OPTION IS A THREE LETTER SEQUENCE FOLLOWED BY A',
     2' CARRIAGE RETURN')
C
C               READ THE INPUT DATA.
C
10    TYPE 5510
5510  FORMAT('0'///' ENTER A CONTROL WORD PLEASE  ',$)
      ACCEPT 1010, KCON
15    DO 20 I = 1,NOPTN
         NC1=I
         IF (KCON.EQ.KCON1(I)) GO TO 25
   20 CONTINUE
      GO TO 30
   25 GO TO (50,95,200,210,235,230,225,250,280,510,285,295,300,310,340,4
     130,440,445,470,480,        145,150,175,180,165,170,185,190,155,160
     2,195,450,455,485,335,330,325,40,35,490,495,500,505,        125,130
     3,315,220,105,110,196,197,     199,36), NC1
C
C               BAD INPUT.
C
30    IF(IOUTP .EQ. 3) WRITE(IOUTP,995) KCON
  995 FORMAT (24H1  INVALID CONTROL CARD ,A3)
      TYPE 5030, KCON
5030  FORMAT(' THE CONTROL WORD [', A3, '] IS INVALID',/,
     1' IF YOU WISH TO ENTER A CORRECT WORD, PLEASE DO'/
     2' TO QUIT, TYPE ''END''  '/' TYPE HEL FOR CONTROL WORDS')
      GO TO 10
35    IF(IOUTP .EQ. 3) WRITE(IOUTP,990)
  990 FORMAT ('1THERE ARE MORE CARDS THAN ALLOWED FOLLOWING A CONTROL
     1CARD.')
      TYPE 5040
5040  FORMAT(' MORE ITEMS SPECIFIED THAN THIS OPTION PERMITS',/
     1' INPUT ANOTHER CONTROL WORD')
      GO TO 10
C
C        HELP FILE
C
36    TYPE *,'                   CONTROL WORDS'
      TYPE *,' '
      TYPE *,'CHP....CHAMBER PRESSURES        ',
     X'NMO....CANCEL MODIFY EXHAUST'
      TYPE *,'                                ',
     X'NOU....CANCEL REGULAR OUTPUR'
      TYPE *,'DET....DETONATION TEMP.         ',
     X'NPA....CANCEL PANIC BUTTON'
      TYPE *,'DVE....DELTA VELOCITY           ',
     X'NSO....CANCEL SPECIAL OPT.'
      TYPE *,'ELM....ADDITIONAL ELEMENTS      ',
     X'NTA....CANCEL TABULATION'
      TYPE *,'END....TERMINATE PROGRAM        ',
     X'NTE....CANCEL TEMPREATURES'
      TYPE *,'ENT....INPUT ENTHALPY           ',
     X'NTH....CANCEL THROAT CALC.'
      TYPE *,'EPS....AREA RATIO CALC.         ',
     X'OPT....WEIGHT OPTIMIZATION'
      TYPE *,'EXP....EXHAUST PRESSURES        ',
     X'OUT....PRINT REGULAR OUTPUT'
      TYPE *,'ION....CONSIDER IONS            ',
     X'PAN....PANIC BUTTON'
      TYPE *,'ITR....CHANGE ITERATION         ',
     X'PUN....PUNCH CARDS FOR PLUME'
      TYPE *,'LIB....PROPELLANT LIBRARY       ',
     X'RED....READ STORED DATA TAPE'
      TYPE *,'MIN....MINOR SPECIES            ',
     X'SEL....SELECT PROPELLANTS'
      TYPE *,'MOD....MODIFY SPECIES           ',
     X'SOP....SPECIAL OPTIMIZATION'
      TYPE *,'MOL....MOLE PROPORTIONS         ',
     X'TAB....TABULATE DATA'
      TYPE *,'                                ',
     X'TEM....CHAMBER TEMPERATURE'
      TYPE *,'NDF....CANCEL DETONATION        ',
     X'THR....THROAT SOLUTION'
      TYPE *,'NEL....CANCEL ADD ELEMENTS      ',
     X'VOL....VOLUME PROPORTIONS'
      TYPE *,'NEP....CANCEL AREA RATIOS       ',
     X'VOP....VOLUME OPTIMIZATION'
      TYPE *,'NEX....SUPPRESS EXHAUST         ',
     X'WTS....WEIGHT PROPORTIONS'
      TYPE *,'NIO....CANCEL IONS              ',
     X'XEQ....EXECUTE THE INPUT'
      TYPE *,'NMI....CANCEL MINOR SPECIES     ',
     X'HEL...PRINT CONTROL WORDS'
      GO TO 10
C
C               END THE TABULATED DATA TAPE.
C
   40 IF (IWHAT.LE.0) GO TO 970
   45 KFILE=JFILE+100
      WRITE (ISTORE) KFILE
      IF (IIFILE.LE.0) IIFILE=1
      IF (NFILE.LE.0) NFILE=JFILE-1
      WRITE (IOUTP,1020) KDATE
      WRITE (IOUTP,1025) IIFILE,NFILE,JFILE
      GO TO 365
C
C               READ THE PROPELLANT LIBRARY DATA.
C
   50 FLAG=.FALSE.
      IF(IOUTP .NE. 3) GO TO 51
      WRITE (IOUTP,1020) KDATE
51    CONTINUE
      TYPE 5050
5050  FORMAT(/////'0FINE. YOU HAVE SELECTED THE ''LIB'' OPTION.'/
     1' YOU MUST NOW ENTER THE DATA DESCRIBING THE '/
     2' REACTANTS TO BE USED.'/' IF THIS IS NOT THE OPTION YOU '/
     3' DESIRED, PLEASE TYPE 1 OTHERWISE SIMPLY CARRIAGE RETURN ',$)
      ACCEPT 5010, II
      IF( II .NE. 0) GO TO 10
      TYPE 5060
5060  FORMAT('0GOOD. NOW ENTER EACH REACTANT AS WILL BE INDICATED'/
     1' AN ''*'' FOR A REACTANT NAME INDICATES THE END OF THE'/
     2' INPUT FOR THIS OPTION',//)
      DO 85 I = 1,10
52    TYPE 5070
5070  FORMAT(' THE REACTANT NAME IS    ',$)
      ACCEPT 5080,NAM1(I), NAM2(I)
5080  FORMAT(2A4)
      IF(NAM1(I) .EQ. NAST) GO TO 90
      TYPE 5090
5090  FORMAT(' IT''S HEAT OF FORMATION AND DENSITY (at input',
     1' conditions in kcal/gmol & g/cc): '/' (NOTE: HF',
     2' only needed for adiabatic rxn, D only for ISP) ...',$)
      ACCEPT 5100, HPROP(I), DENS(I)
5100  FORMAT(2F)
      TYPE 5110
5110  FORMAT(' ENTER NOW IT''S ELEMENTAL COMPOSITION'/' (Element in A2',
     1' right justified field, then a comma, then comp. with a ".")')
      ACCEPT 5120, (NAME(J), QEI(J), J=1,11)
5120  FORMAT(11(A2,1X,F))
      NINLST=I
      NEL=0
      QMOLWT(I)=0.0
      IF (DENS(I).LE.0.0) DENS(I)=1.0
      DO 55 J=1,NLEL
   55 QE(I,J)=0.0
      DO 75 K=1,11
      IF (QEI(K).EQ.0.0) GO TO 80
      DO 60 L=1,NLEL
      IF (NAME(K).EQ.MELM(L)) GO TO 70
   60 CONTINUE
      WRITE (IOUTP,1030) NAM1(I),NAM2(I),NAME
   65 WRITE (IOUTP,980) NAME(K)
      GO TO 52
   70 NEL=NEL+1
      QE(I,L)=QEI(K)
   75 QMOLWT(I)=QMOLWT(I)+ATWT(L)*QEI(K)
   80 Q(I)=HPROP(I)/QMOLWT(I)
      IF(IOUTP .NE. 3) GO TO 81
      WRITE (IOUTP,1030) NAM1(I),NAM2(I),(NAME(J),J=1,NEL)
      WRITE (IOUTP,1035) HPROP(I),(QEI(J),J=1,NEL)
      WRITE (IOUTP,1035) DENS(I)
81    IF (QEI(1).NE.0.0) GO TO 85
      WRITE (IOUTP,1165)
      GO TO 52
   85 CONTINUE
   90 CONTINUE
      DO 91 I = 1,NINLST
      NPROP = I
91    IDPROP(I) = I
      IF (NINLST.EQ.10) GO TO 10
      GO TO 10
C
C               SELECT PROPELLANTS FROM THE LIBRARY.
C
95    TYPE 5230
5230  FORMAT(//' NOW, SPECIFY WHICH LIBRARY INGREDIENTS THIS RUN',
     1' NEEDS',/' LIST THE INDEXES SEPARATED BY COMMAS ',$)
      ACCEPT 5240, (IDPROP(I), I=1,9)
5240  FORMAT(9I)
      DO 100 I = 1,9
      IF( IDPROP(I) .EQ. 0) GO TO 10
100   NPROP = I
      GO TO 10
C
C               PROGRAM FLAGS.
C
  105 IFROZN=1
      GO TO 10
  110 IFROZN=0
      GO TO 10
  125 IPART=1
      GO TO 10
  130 IPART=0
      GO TO 10
  145 NNN=0
      GO TO 10
  150 NNN=1
      GO TO 10
  155 MINOR=0
      GO TO 10
  160 MINOR=1
      GO TO 10
  165 NPRNT1=1
      GO TO 10
  170 NPRNT1=0
      GO TO 10
  175 ION=1
      GO TO 10
  180 ION=0
      GO TO 10
  185 NCON=0
      GO TO 10
  190 NCON=88
      GO TO 10
  195 ACCEPT 5010, LITER
      WRITE (IOUTP,1000) LITER
      GO TO 10
196   NENT = 1
      TYPE 5150
5150  FORMAT('0'/' REACTANT ENTHALPY (kcal/100g) = ',$)
      ACCEPT 5160, HIK
5160  FORMAT(10F)
      GO TO 10
197   NENT = 0
      GO TO 10
199   TYPE 5180
5180  FORMAT('0'/' LOWER LIMIT FOR PRINTING SPECIE PRODUCT = ',$)
      ACCEPT 5160, CTRPT
      GO TO 10
C
C               READ IN THE CHAMBER PRESSURES.
C
  200 DO 205 I=1,10
         TYPE 5290
5290     FORMAT('0'/' CHAMBER PRESSURE (psia) = ',$)
         ACCEPT 5160, PSIC(I)
         IF( PSIC(I) .EQ. 0.0) GO TO 10
  205 NCHP=I
      GO TO 10
C
C               READ IN THE EXHAUST PRESSURES.
C
  210 DO 215 I=1,10
         TYPE 5300
5300     FORMAT( '0'/' EXHAUST PRESS (psia) = ', $)
         ACCEPT 5160, PSIX(I)
         IF( PSIX(I) .EQ. 0.0) GO TO 10
  215 NEXP=I
      GO TO 10
  220 NEXP=0
      GO TO 10
C
C               READ IN THE VOLUME PROPORTIONS.
C
  225 KPOINT=3
      GO TO 240
C
C               READ IN THE MOLE PROPORTIONS.
C
  230 KPOINT=2
      GO TO 240
C
C               READ IN THE MASS PROPORTIONS.
C
  235 KPOINT=1
  240 NDF=0
      DO 245 I=1,40
         GO TO (241, 242, 243), KPOINT
241      TYPE 5310
5310  FORMAT('0MASS PROPORTIONS OF SELECTED LIBRARY INGREDIENTS',/,
     1  5X,'   ', $)
         GO TO 244
242      TYPE 5320
5320  FORMAT('0MOLE PROPORTION OF SELECTED LIBRARY INGREDIENTS',/,
     1  5X,'   ', $)
         GO TO 244
243      TYPE 5330
5330  FORMAT('0VOLUME PROPORTIONS OF SELECTED LIBRARY INGREDIENTS',/,
     1  5X,'   ', $)
244      ACCEPT 5160, (QMASS(J,I), J=1,9)
         IF(QMASS(1,I) .EQ. 0.0) GO TO 10
  245    NPOINT=I
      GO TO 10
C
C               MAKE MODIFICATIONS IN THE EXHAUST PRODUCTS.
C
250   TYPE 5340
5340  FORMAT(' NOT YET RESTRUCTURED TO NEW FORMAT FOR INPUT'/,
     1  ' BE CAREFUL... USE AT OWN RISK... READ USER''S MANUAL'/,
     2  ' THE PROGRAM WILL LOOK FOR A FOR002.DAT DATA FILE ')
      ICALDA=1
      NCHNG=260
  255 READ (INTAPE,1040) KCON,(NAME(J),QEM(NCHNG,J),J=1,4),KCHARG(NCHNG)
     1,IMPT(NCHNG),MODIFY,HR(NCHNG),SR(NCHNG),NAMX1(NCHNG),NAMX2(NCHNG)
      IF (KCON.NE.KCON1(39)) GO TO 15
      IF (MODIFY.EQ.0) HR(NCHNG)=-1.0E10
      IF (MODIFY.EQ.1) SR(NCHNG)=-1.0E10
      DO 265 K=1,4
         IF (QEM(NCHNG,K).LE.0.0) GO TO 270
         DO 260 L=1,NLEL
            IF (NAME(K).EQ.MELM(L)) GO TO 265
  260    CONTINUE
         GO TO 65
  265    NAMEM(NCHNG,K)=MELM(L)
  270 IF (MODIFY.LE.1) GO TO 275
      READ (INTAPE,1015) DUMMY,(Z(NCHNG,J),J=1,5)
      READ (INTAPE,1015) DUMMY,(Z(NCHNG,J),J=6,10)
  275 NCHNG=NCHNG-1
      GO TO 255
  280 NCHNG=260
      ICALDA=1
      GO TO 10
C
C               READ IN THE AREA RATIOS.
C
  285 DO 290 I=1,10
         TYPE 5350
5350     FORMAT('0'/' NOZZLE EXPANSION RATIO INPUT = ',$)
         ACCEPT 5160, EPS(I)
         IF( EPS(I) .EQ. 0.0) GO TO 10
  290    NEPS=I
      GO TO 10
  295 NEPS=0
      GO TO 10
C
C               READ IN THE TEMPERATURES.
C
300   ITEMP = 1
      DO 305 I=1,20
         TYPE 5360
5360     FORMAT('0'/' PRODUCT TEMPERATURE INPUT (K) = ',$)
         ACCEPT 5160, TG(I)
         IF( TG(I) .EQ. 0.0) GO TO 10
  305    NTEMP=I
      GO TO 10
310   NTEMP = 1
      ITEMP = 0
      GO TO 10
C
C               SAY SOMETHING.
C
  315 WRITE (IOUTP,1020) KDATE
      JLINED=0
  320 TYPE 5370
5370  FORMAT('0PLEASE INPUT YOUR COMMENTS',/
     1' AN ''*'' IN COLUMN 1 TERMINATES COMMENT INPUT',//)
322   ACCEPT 1155, ISAY
      IF( ISAY(I) .EQ. NAST) GO TO 10
      IF( IOUTP .NE. 3) GO TO 322
      WRITE (IOUTP,1160) ISAY
      JLINED=JLINED+1
      IF (JLINED.EQ.40) GO TO 315
      GO TO 322
C
C               TABULATED DATA INPUT.
C               'NTA'
C
  325 MANY=0
      FLAG=.TRUE.
      GO TO 10
C
C               'RED'
C
330   TYPE 5340
      IWHAT=IWHAT-1
      MANY=-1
C
C               'STO'
C
335   TYPE 5340
      READ (INTAPE,1010) DUMMY,IIFILE,NFILE
      TABTP=.TRUE.
      IF (MANY.EQ.(-1).AND.IWHAT.EQ.0) GO TO 45
      GO TO 365
C
C               'TAB'
C
340   TYPE 5340
      TABTP=.TRUE.
      FLAG=.FALSE.
      IWHAT=1
      DO 345 I=1,10
      READ (INTAPE,1050) KCON,LABEL1(I),LABEL2(I),IROW(I),ICOL(I)
      IF (KCON.NE.KCON1(39)) GO TO 350
  345 MANY=I
  350 IF (IIFILE.GT.JFILE) GO TO 365
      IF (JFILE-1) 355,355,360
  355 IIFILE=0
      REWIND ISTORE
  360 IF (MANY.EQ.10) GO TO 10
      GO TO 15
C
C               INITIALIZE THE DATA TAPE.
C
  365 REWIND ISTORE
      JFILE=IIFILE
      READ (ISTORE) LFILE
  370 IF (IIFILE.EQ.(LFILE-100)) GO TO 390
      READ (ISTORE) LFILE
      READ (ISTORE) LFILE
  375 READ (ISTORE) LFILE
      IF (LFILE.GT.100) GO TO 370
      READ (ISTORE) LFILE,NNDF
      IF (NNDF.GE.1) LFILE=20000
  380 DO 385 I=1,LFILE
         READ (ISTORE) ITT
         IF (ITT.EQ.1234) GO TO 375
  385 CONTINUE
      GO TO 375
C
C               READ DATA TAPE AND PRINT.
C
  390 IF (NC1.NE.38.AND.NC1.NE.40) GO TO 10
      NSAVE=IIFILE
  395 WRITE (IOUTP,1020) KDATE
      WRITE (IOUTP,1055) NSAVE
      READ (ISTORE) NINLST,(NAM1(I),NAM2(I),I=1,NINLST)
      READ (ISTORE) MANY,(LABEL1(I),LABEL2(I),I=1,MANY)
  400 READ (ISTORE) NPROP
      IF (NPROP.LT.100) GO TO 405
      NSAVE=NPROP-100
      IF (NSAVE.GT.NFILE.AND.NC1.GE.40) GO TO 970
      IF (NSAVE.GT.NFILE) GO TO 10
      GO TO 395
  405 READ (ISTORE) NPOINT,NDF,       (IDPROP(I),I=1,NPROP),PC,TC
      IF (NDF.GE.1) NPOINT=20
      DO 410 J=1,NPROP
         I=IDPROP(J)
         NAME1(J)=NAM1(I)
  410    NAME2(J)=NAM2(I)
  415 WRITE (IOUTP,1020) KDATE
      WRITE (IOUTP,1135) PC
      IF (TC.NE.0.0) WRITE (IOUTP,1140) TC
      WRITE (IOUTP,1060) (NAME1(J),NAME2(J),J=1,NPROP),IMDENS,(LABEL1(J)
     1,LABEL2(J),J=1,MANY)
      WRITE (IOUTP,1060)
      DO 420 I=1,NPOINT
         READ (ISTORE) ITT,(QMASS(J,I),J=1,NPROP),BLKDNS,(TABOUT(J),J=1,
     1      MANY)
         IF (ITT.EQ.1234) GO TO 425
            ITT=ITT1(ITT+1)
  420    WRITE (IOUTP,1065) ITT,(QMASS(J,I),J=1,NPROP),BLKDNS,(TABOUT(J)
     1      ,J=1,MANY)
  425 IF (ITT.EQ.1234) GO TO 400
      IF (NDF.GE.1) GO TO 415
      GO TO 400
C
C               READ IN NEW ELEMENTS.
C
430   TYPE 5340
      DO 435 I=NLEL1,55
         READ (INTAPE,1005) KCON,MELM(I),DUMMY,ATWT(I)
         IF (KCON.NE.KCON1(39)) GO TO 15
  435    NLEL=I
      GO TO 10
  440 NLEL=NLEL1-1
      GO TO 10
C
C               READ IN THE OPTIMIZATION INPUT.
C
445   TYPE 5340
      KPOINT=1
      GO TO 460
450   TYPE 5340
      KPOINT=2
      GO TO 460
455   TYPE 5340
      KPOINT=3
  460 NPOINT=1
      WRITE (IOUTP,1020) KDATE
      WRITE (IOUTP,1070)
      DO 465 I=1,9
         READ (INTAPE,1015) KCON,(ET(I,J),J=1,9)
         IF (KCON.NE.KCON1(39)) GO TO 15
         WRITE (IOUTP,1065) KCON1(39),(ET(I,J),J=1,NPROP)
         READ (INTAPE,1015) DUMMY,ECONST(I),COI(I),ECMIN(I),ECMAX(I)
         WRITE (IOUTP,1065) KCON1(39),ECONST(I),COI(I),ECMIN(I),
     1      ECMAX(I)
  465    NDF=I
      GO TO 10
C
C               READ IN THE DETONATION INPUT.
C
  470 DO 475 I=1,10
         TYPE 5470
5470     FORMAT('0'/' INITIAL TEMPERATURE (K) = ',$)
         ACCEPT 5160, TU(I)
         IF( TU(I) .EQ. 0.0) GO TO 10
  475 NDET=I
      GO TO 10
  480 NDET=0
      GO TO 10
C
C               SPECIAL OPTIMIZATION
C
485   TYPE 5340
      READ (INTAPE,1010) KCON,IROWSP,ICOLSP
      IF (KCON.NE.KCON1(39)) GO TO 35
      SOP=.TRUE.
      GO TO 10
  490 SOP=.FALSE.
      GO TO 10
C
C               READ INPUT FOR DELTA VELOCITY
C
495   TYPE 5340
      READ (INTAPE,1015) KCON,DLMASS,DLVOLP
      IF (KCON.NE.KCON1(39)) GO TO 35
      READ (INTAPE,1010) KCON,IROWDL,ICOLDL
      IF (KCON.NE.KCON1(39)) GO TO 35
      WFVP=DLMASS/DLVOLP
      DVE=.TRUE.
      GO TO 10
C
C               READ INPUT FOR AIR AUGMENTED ISP
C
500   TYPE 5340
      READ (INTAPE,1015) KCON,AGTEMP,AGMACH
      IF (KCON.NE.KCON1(39)) GO TO 35
      READ (INTAPE,1010) KCON,IROWAG,ICOLAG
      IF (KCON.NE.KCON1(39)) GO TO 35
      AGTEMP=(49.02*SQRT(AGTEMP)*AGMACH)/32.174
      AAG=.TRUE.
      GO TO 10
  505 AAG=.FALSE.
      GO TO 10
C
C               EXECUTE THE PROBLEM.
C
C               EXHAUST SPECIES NEEDED.
C
510   TYPE 5400
5400  FORMAT(' EDWS IS NOW EXECUTING')
      NM=0
      LKDROP=3
      DO 530 J=1,NLEL
         DO 515 K=1,NPROP
            I=IDPROP(K)
            IF (I.LE.0.OR.I.GT.NINLST) GO TO 10
            IF (QE(I,J)) 515,515,520
  515    CONTINUE
         GO TO 530
  520    NM=NM+1
         IF (ION.NE.1.AND.NM.LE.11.OR.ION.EQ.1.AND.NM.LE.10) GO TO 525
            WRITE (IOUTP,1145)
            GO TO 10
  525    IEV(NM)=MELM(J)
         IEVN(NM) = J
  530 CONTINUE
      NMP1=NM+1
      IF (NM-NMP) 550,535,550
  535 IF (ICALDA-1) 540,550,540
  540 DO 545 I=1,NM
         IF (IEV(I)-IEVP(I)) 550,545,550
  545 CONTINUE
      IF (ION.NE.IONPRE) GO TO 550
      NSYS=0
      IF (NCON.EQ.66.OR.NCON.EQ.99) GO TO 10
      GO TO 555
  550 CALL XDATA
      IF (NCON.EQ.66.OR.NCON.EQ.99) GO TO 10
      ICALDA=0
      IONPRE=ION
      NSYS=1
      NKIN=0
C
C               SOLVE FOR EACH CHAMBER PRESSURE.
C
  555 TO=3500.0
      DO 950 ICP=1,NCHP
         ATMOSC=PSIC(ICP)/14.696
C
C               LOOP FOR EACH TEMPERATURE.
C
         DO 945 IHOT=1,NTEMP
C
C               TABULATE.
C
            IF (MANY.EQ.0) GO TO 570
               IF (FLAG) GO TO 565
                  IF (IIFILE.EQ.JFILE) GO TO 560
                     KFILE=JFILE+100
                     WRITE (ISTORE) KFILE
  560             JFILE=JFILE+1
                  WRITE (ISTORE) NINLST,(NAM1(I),NAM2(I),I=1,NINLST)
                  WRITE (ISTORE) MANY,(LABEL1(I),LABEL2(I),I=1,MANY)
  565             WRITE (ISTORE) NPROP
               WRITE (ISTORE) NPOINT,NDF,       (IDPROP(I),I=1,NPROP),
     1         PSIC(ICP),TG(IHOT)
               FLAG=.TRUE.
C
C               OPTIMIZE.
C
  570          IF (NDF.EQ.0) GO TO 595
            NI=NDF
            DO 575 I=1,NDF
               EC(I)=ECONST(I)
               KU(I)=0
               IDU(I)=0
  575          SPIM(I)=0.0
  580       LV=NDF
            LB=LV+1
            DO 585 I=1,NDF
               EL(I,LB)=EC(I)
               DO 585 J=1,LV
  585             EL(I,J)=ET(I,J)
            CALL SLE
            DO 590 I=1,NDF
               IF (ANS(I).LE.0.0) GO TO 935
  590          QMASS(I,1)=ANS(I)
C
C               SOLVE FOR EACH POINT
C
  595       DO 905 IPOINT=1,NPOINT
C
C               INITIALIZE CHAMBER CONDITIONS.
C
               ATMOS=ATMOSC
               IF (NSYS) 615,600,615
  600          DO 605 I=1,NT
  605             Y(I)=YC(I)
               TO=TC
               NKIN=NKINC
               IF(NKIN.LE.0) GO TO 615
                  DO 610 J=1,NKIN
  610                IDKIN(J)=IDKINC(J)
C
C               SYSTEM ROUTINE TO RETURN THE TIME IN SECONDS.
C               SEE SUBROUTINE 'OUTPUT'.
C
  615          CALL CLOCK (TIMES)
C
               INTIAL=0
               NFROZN=0
C
C               JUGGLE A VOLUME OF MASSIVE MOLES.
C
               IF (NCON.EQ.88) GO TO 620
                  WRITE (IOUTP,1020) KDATE
                  WRITE (IOUTP,1080)
  620          SUMVOL=0.0
               SUMMOL=0.0
               SUMMAS=0.0
               DO 645 J=1,NPROP
                  IF (QMASS(J,IPOINT).GT.0.0) GO TO 625
                     WRITE (IOUTP,1150)
                     GO TO 10
  625             K=IDPROP(J)
                  GO TO (640,635,630), KPOINT
  630             QMASS(J,IPOINT)=QMASS(J,IPOINT)*DENS(K)
                  GO TO 640
  635             QMASS(J,IPOINT)=QMASS(J,IPOINT)*QMOLWT(K)
  640             SUMMAS=SUMMAS+QMASS(J,IPOINT)
                  VOL(J)=QMASS(J,IPOINT)/DENS(K)
                  SUMVOL=SUMVOL+VOL(J)
                  QMOL(J)=QMASS(J,IPOINT)/QMOLWT(K)
                  SUMMOL=SUMMOL+QMOL(K)
                  IF( NCON .EQ. 88) GO TO 645
                     WRITE (IOUTP,1090) NAM1(K),NAM2(K),HPROP(K),DENS(K)
     1                 ,QMASS(J,IPOINT),QMOL(J),VOL(J)
645            CONTINUE
               IF( NENT .EQ. 0) HIK = 0.0
      DO 650 J=1,NPROP
         K=IDPROP(J)
         PCT(K)=(100.0*QMASS(J,IPOINT))/SUMMAS
         IF( NENT .EQ. 0) HIK = HIK + Q(K)*PCT(K)
650   CONTINUE
      HI=HIK*1000.0
      NM=NMP1-1
      BLKDNS=SUMMAS/SUMVOL
      IF (AAG) BLKDNS=(SUMMAS-QMASS(NPROP,IPOINT))/(SUMVOL-VOL(NPROP))
      QM1=SUMMAS/SUMMOL
      BTOT=0.0
      DO 665 J=1,NM
         K=IEV(J)
         DO 655 L=1,NLEL
            K=L
            IF (IEV(J).EQ.MELM(L)) GO TO 660
  655    CONTINUE
  660    B(J)=0.0
         DO 665 I=1,NPROP
            L=IDPROP(I)
            B(J)=B(J)+QE(L,K)*PCT(L)/QMOLWT(L)
  665       BTOT=BTOT+B(J)
      IF (ION.EQ.1) B(NM+1)=0.0
      BMIN=B(1)
      DO 670 J=1,NM
  670    BMIN=AMIN1(B(J),BMIN)
      IF (NCON.EQ.88) GO TO 675
         WRITE (IOUTP,1035)
         WRITE (IOUTP,1031) GATOMS(1),GATOMS(2),(IEV(J),J=1,NM)
         WRITE (IOUTP,1085) GATOMS(3),GATOMS(4),(B(J),J=1,NM)
         WRITE (IOUTP,1095) HIK,BLKDNS
  675 IF (ION.NE.0) NM=NMP1
C
C               SPECIFIED TEMPERATURES.
C
      IF( ITEMP .EQ. 0) GO TO 695
      NCTXP=4
      IF (NEXP.EQ.0.AND.NEPS.EQ.0) GO TO 680
C
C               EXPANSION SOLUTIONS FOR TEMPERATURES REQUIRED.
C
      TO=TG(IHOT)
      ANS(23)=0.0
      GO TO 725
C
C               NO EXPANSION SOLUTIONS FOR TEMPERATURES REQUIRED.
C
  680 DO 690 J=1,NTEMP
      TO=TG(J)
      ANS(23)=0.0
      CALL EQUIL
      ICHECK=1
      GO TO 955
  685 IF (J.GE.2) INTIAL=1
  690 CONTINUE
      GO TO 855
C
C               DETONATE.
C
  695 IF (NDET.LT.1) GO TO 720
      QM2=250.0/BTOT
      PU=PSIC(ICP)/14.696
      GAMMA=1.25
      ATMOS=0.0
      HI1=HI
      NCTXP=0
      DO 715 I=1,NDET
      WRITE (IOUTP,1020) KDATE
      RHO1=(PU*QM1)/(82.057*TU(I))
      WRITE (IOUTP,1100)
      WRITE (IOUTP,1105)
      WRITE (IOUTP,1110) PSIC(ICP),TU(I),QM1,RHO1,HI1
      WRITE (IOUTP,1115)
      WRITE (IOUTP,1105)
C
C               SYSTEM ROUTINE TO RETURN THE TIME IN SECONDS.
C               SEE STATEMENT NUMBER 580.
C
      CALL CLOCK (TIMES)
C
      DO 705 J=1,10
      U2=299.16*SQRT(GAMMA*TO/QM2)
      AC=(QM2*TU(I)*GAMMA)/(QM1*TO*PU)
      BC=1.0+GAMMA
      BCBC=BC*BC
      ACPU4=+4.0*AC*PU
      IF (BCBC.GE.ACPU4) GO TO 700
      WRITE (IOUTP,985)
      GO TO 715
  700 ATMOST=(BC+SQRT(BCBC-ACPU4))/(2.0*AC)
      IF (ABS(ATMOST-ATMOS).LT.(0.001*ATMOS)) GO TO 710
      ATMOS=ATMOST
      DLPR=.1*ATMOS
      RHO2=(ATMOS*QM2)/(82.057*TO)
      UD=(U2*RHO2)/(RHO1)
      udm=ud*2.54*12./1.e5					!MWB mod
      HI=HI1+((UD*UD-U2*U2)/901.1)
      NCTXP=0
      CALL EQUIL
      TP=TO
      QM2=100.0/YBAR
      RP=(ATMOS*QM2)/TO
      ATMOS=ATMOS-DLPR
      NCTXP=1
      CALL EQUIL
      LOUT=0
      DLRH=RP-((ATMOS*100.0)/(YBAR*TO))
      ATMOS=ATMOS+DLPR
      TO=TP
      GAMMA=(QM2*DLPR)/(TO*DLRH)
      JLINED=J
  705 WRITE (IOUTP,1110) OUT(1,1),TO,QM2,RHO2,HI
  710 continue
      WRITE (IOUTP,2110) OUT(1,1)
 2110 FORMAT (/,28X,'FINAL DETONATION CONDITIONS',
     &        /,8X,14HPRESSURE (PSI),5X,f10.1)
      WRITE (IOUTP,2120) TO
 2120 FORMAT (8X,'TEMPERATURE (K)',6X,f8.1)
      WRITE (IOUTP,2130) QM2
 2130 FORMAT (8X,14HMOLECULAR WT  ,8X,f8.2)
      WRITE (IOUTP,1120) UD,UDM,GAMMA,JLINED
      WRITE (IOUTP,1125)
      LOUT=1
      CALL OUTPUT
  715 LOUT=0
      GO TO 855
C
C               FIND CHAMBER CONDITIONS.
C
  720 NCTXP=0
      ANS(1)=10.0
      ANS(23)=10.0
  725 CALL EQUIL
      IF (NCTXP.EQ.4) HI=HBAR
      NSYS=0
      ICHECK=2
      GO TO 955
C
C               FIND THROAT CONDITIONS.
C
  730 IF (NNN.NE.0) GO TO 790
      NCTXP=2
      ICHECK=6
      PTEMP=0.0
      ITT=0
      ATMOSP=ATMOS
      TP=TO
      HP=HBAR
      ATMOS=0.55*ATMOS
      TO=TC*(0.55)**(YBAR*R/CBAR)
      NOCP=0
      MPDP=0
      ANS(1)=10.0
  735 CALL EQUIL
      IF (NPRNT1.EQ.1) CALL OUTPUT
C
C       MPD = 1 MEANS THE SOLUTION STRADDLES A PHASE TRANSITION
C
      IF (NOCP.LT.3) GO TO 745
      FNOCP=NOCP
      PTEMP=(PTEMP*(FNOCP-3.0)+ATMOS)/(FNOCP-2.0)
      IF (NOCP-9) 745,740,745
  740 ATMOSN=PTEMP
      GO TO 770
  745 IF (MPDP-MPD) 755,750,755
  750 IF (MPD) 760,765,760
  755 ATMOSN=ATMOS+0.5
      TN=TO
      GO TO 770
  760 PHC=(HP-HBAR)/(ATMOSP-ATMOS)
      PHCPO=PHC*ATMOS
      ATMOSN=2.0*(HI-HBAR+PHCPO)/(3.0*PHC)
      TN=TO
      IF (ABS(ATMOSN-ATMOS)-0.1) 775,775,770
  765 PTC=(ALOG(TP/TO))/(ALOG(ATMOSP/ATMOS))
      CSH=(HP-HBAR)/(TP-TO)
      CSHTO=CSH*TO
      RPTC=1.0/PTC
      DUM1=((HI-HBAR+CSHTO)/CSHTO)*((2.0-2.0*PTC)/(2.0-PTC))
      ATMOSN=ATMOS*DUM1**RPTC
      TN=TO*(ATMOSN/ATMOS)**PTC
      IF (ABS(TN-TO)-10.0) 775,775,770
  770 ATMOSP=ATMOS
      MPDP=MPD
      TP=TO
      HP=HBAR
  775 IF (ABS(ATMOSN-ATMOS).LE.DELPO) GO TO 955
  780 ATMOS=ATMOSN
      TO=TN
      NOCP=NOCP+1
      LOUT=1
      IF (NOCP.LE.10) GO TO 735
      LOUT=2
      ITT=1
      GO TO 955
  785 IF (NCON.EQ.88) GO TO 790
      WRITE (IOUTP,975) CSTAR
C
C               SPECIFIED EXHAUST PRESSURES.
C
  790 IF (NEXP.EQ.0) GO TO 800
      ICHECK=3
      NCTXP=1
      DO 795 I=1,NEXP
      TP=TO
      ATMOSP=ATMOS
      ATMOS=PSIX(I)/14.696
      TO=TP*(ATMOS/ATMOSP)**(YBAR*R/CBAR)
      ANS(1)=10.0
      CALL EQUIL
      NFROZN=I
      TFROZN(NFROZN)=TO
      GO TO 955
  795 CONTINUE
C
C               SPECIFIED AREA RATIOS.
C
  800 IF (NEPS.EQ.0) GO TO 845
      IF (NNN.EQ.1) GO TO 845
      HPR=HC
      TPR=TC
      ICHECK=4
      DO 840 I=1,NEPS
      IF ((MPD+MPDP).LE.0) GO TO 805
      HPR=HBAR
      TPR=TO
      GO TO 835
  805 CBARSH=(HPR-HBAR)/(TPR-TO)
      TOOT=TO/1000.0
      G5=CBARSH/(R*YBAR)
      G2=1.0-G5
      G1=(942.706*PC*YBAR*(TOOT**G5))/(ATMOS*CSTAR)
      G3=(HC-HBAR+CBARSH*TO)/1000.0
      JTER=-1
      TKOTT=0.9*TOOT
  810 TKOT=TKOTT
      JTER=JTER+1
      IF (JTER-10) 815,830,830
  815 TKE1=TKOT**G2
      SQ=SQRT(V)
      EPT=(EPS(I)*SQ)/(G1*TKE1)-1.0
      TKOTT=TKOT+EPT/((CBARSH/(2.0*V))+G2/TKOT)
      IF (TKOTT/TKOT-0.9) 820,825,825
  820 TKOTT=0.9*TKOT
      GO TO 810
  825 IF (ABS(TKOTT-TKOT)-0.001) 830,810,810
  830 TKOT=TKOTT
      TPR=TO
      TO=TKOT*1000.0
      HPR=HBAR
      ATMOS=ATMOS*(TO/TPR)**G5
  835 NCTXP=3
      D=EPS(I)*ATW
      ANS(2)=10.0
      CALL EQUIL
      NFROZN=NFROZN+1
      PSIX(NFROZN)=OUT(1,LOUT)
      TFROZN(NFROZN)=TO
      GO TO 955
  840 CONTINUE
C
C               FROZEN CALCULATION.
C
  845 IF (IFROZN.EQ.0) GO TO 855
      NCTXP=5
      ICHECK=5
      DO 850 I=1,NFROZN
      ATMOS=PSIX(I)/14.696
      TO=TFROZN(I)
      CALL EQUIL
      GO TO 955
  850 CONTINUE
  855 IF (LOUT.GT.0) CALL OUTPUT
C
C               CALCULATE DELTA VELOCITY
C
  860 IF (DVE) OUT(20,1)=OUT(IROWDL,ICOLDL)*32.174*ALOG(((BLKDNS*62.375)
     1+WFVP)/WFVP)
C
C               INITIALIZE QMASS
C
      DO 875 J=1,NPROP
      GO TO (875,870,865), KPOINT
  865 QMASS(J,IPOINT)=VOL(J)
      GO TO 875
  870 QMASS(J,IPOINT)=QMOL(J)
  875 CONTINUE
C
C               CALCULATE AIR AUGMENTED ISP
C
      IF (.NOT.AAG) GO TO 880
      AGMACH=QMASS(NPROP,IPOINT)/(SUMMAS-QMASS(NPROP,IPOINT))
      OUT(20,2)=OUT(IROWAG,ICOLAG)*(AGMACH+1.0)-AGTEMP*AGMACH
C
C               TABULATE.
C
  880 IF (MANY.EQ.0) GO TO 905
      DO 900 I=1,MANY
      IROW1=IROW(I)
      ICOL1=ICOL(I)
      IF (IROW1.LE.0.OR.IROW1.GT.20) GO TO 885
      TABOUT(I)=OUT(IROW1,ICOL1)
      GO TO 900
  885 DO 890 J=1,NSIN
      K=IDSIN(J)
      IF (NAMX1(K).NE.LABEL1(I)) GO TO 890
      IF (NAMX2(K).NE.LABEL2(I)) GO TO 890
      GO TO 895
  890 CONTINUE
      TABOUT(I)=0.0
      GO TO 900
  895 TABOUT(I)=YOUT(K,ICOL1)
  900 CONTINUE
      WRITE (ISTORE) ITT,(QMASS(J,IPOINT),J=1,NPROP),BLKDNS,(TABOUT(J),J
     1=1,MANY)
      ITT=0
  905 CONTINUE
C
C               OPTIMIZE.
C
      IF (NDF.EQ.0) GO TO 940
      NI=NDF
      IF (SOP) SPI=OUT(IROWSP,ICOLSP)
  910 IF (SPI.LT.SPIM(NI)) GO TO 925
      SPIM(NI)=SPI
  915 IF (IDU(NI).GT.0) GO TO 920
      EC(NI)=EC(NI)-COI(NI)
      KU(NI)=KU(NI)+1
      IF (EC(NI).LT.ECMIN(NI)) GO TO 925
      GO TO 580
  920 EC(NI)=EC(NI)+COI(NI)
      IF (EC(NI).GT.ECMAX(NI)) GO TO 925
      GO TO 580
  925 IF (IDU(NI).GT.0) GO TO 930
      IF (KU(NI).GT.1) GO TO 930
      IDU(NI)=1
      EC(NI)=EC(NI)+COI(NI)
      GO TO 915
  930 SPI=SPIM(NI)
      KU(NI)=0
      IDU(NI)=0
      SPIM(NI)=0
      NI=NI-1
      IF (NI.LE.0) GO TO 935
      IF (COI(NI)) 910,930,910
  935 IF (MANY.EQ.0) GO TO 940
      ITT=1234
      WRITE (ISTORE) ITT,(QMASS(J,1),J=1,NPROP),BLKDNS,(TABOUT(J),J=1,MA
     1NY)
      ITT=0
  940 IF (NCTXP.EQ.4) GO TO 950
  945 CONTINUE
  950 CONTINUE
      TYPE 5500
5500  FORMAT(' EDWS IS THROUGH EXECUTING AND IS READY FOR',
     1  ' ANOTHER CASE')
      GO TO 10
C
C               TEST FOR NON-CONVERGENCE.
C
  955 IF (ITE(LOUT).LE.LITER) GO TO 960
      CALL OUTPUT
      IF (ITT.EQ.1) ITT=3
      IF (ITT.NE.3) ITT=2
      WRITE (IOUTP,1130)
      GO TO 860
C
C               TEST FOR 6 COLUMNS OF PRINT.
C
  960 IF (LOUT.LT.6) GO TO 965
      CALL OUTPUT
      WRITE (IOUTP,1020) KDATE
  965 GO TO (685,730,795,840,850,785), ICHECK
C
C               SYSTEM ROUTINE TO REWIND TAPES PAST LOAD POINT.
C
  970 IF (TABTP) CALL UNLOAD (ISTORE)
C
      CALL EXIT
C
C
  975 FORMAT (17X,15HCSTAR (FT/SEC)=,F14.3)
  980 FORMAT (10X,12HTHE ELEMENT ,A2,12H IS INVALID.)
  985 FORMAT (/,10X,48HTHERE IS NO SOLUTION TO THIS DETONATION PROBLEM.)
 1000 FORMAT (35H1THE COUNTER TO LIMIT THE NUMBER OF/26H ITERATIONS IS N
     1OW SET AT I4,11H.  ANY DATA/40H POINT WHICH EXCEEDS THIS COUNTER S
     2HOULD/40H BE VIEWED CRITICALLY BEFORE ACCEPTANCE.)
 1005 FORMAT (A3,A4,A3,2F8.0,6(A2,F6.0),A3)
 1010 FORMAT (A3,2I8)
 1015 FORMAT (A3,9F8.0)
 1020 FORMAT (1H1,10X,18HCOMPUTER RUN DATE ,A3,I3,1H,,I5,/)
 1025 FORMAT (5X,5HFILES,I3,8H THROUGH,I3,19H HAVE BEEN CREATED.,/,5X,4H
     1FILE,I3,37H IS THE NEXT FILE NUMBER ON THE TAPE.,/)
 1030 FORMAT (1X,2A4,11(6X,A2))
 1031 FORMAT (1X,2A5,11(6X,A2))
 1035 FORMAT (3X,F10.4,11F8.4)
 1040 FORMAT (A3,4(A2,F6.0),I2,I6,I8,2F8.0,2A4)
 1045 FORMAT (3X,5(A2,F6.0))
 1050 FORMAT (A3,2A4,2X,I4,I8)
 1055 FORMAT (1X,10HBEGIN FILE,I3)
 1060 FORMAT (4X,14(A6,A3))
 1065 FORMAT (1X,A2,14F9.3)
 1070 FORMAT (11X,18HOPTIMIZATION INPUT)
 1080 FORMAT('  PROPELLANT     HF     DENSITY   WEIGHT    MOLES',
     1  '    VOLUME')
 1085 FORMAT (1X,2A5,11F8.4)
 1090 FORMAT(1X,2A4,4F10.4,2X,E12.5)
 1095 FORMAT (11H0ENTHALPY =,F10.5,10X,10H DENSITY =,F5.3)
 1100 FORMAT (/,30X,23HUNBURNED GAS PARAMETERS)
 1105 FORMAT (/,4X,14HPRESSURE (PSI),2X,8HTEMP (K),4X,5HMOLWT,3X,14HDENS
     1ITY (G/CC),4X,19HENTHALPY (CAL/100G))
 1110 FORMAT (2X,2F13.3,F10.3,E16.6,F17.3)
 1115 FORMAT (/,30X,21HBURNED GAS PARAMETERS)
 1120 FORMAT (/,3X,4HUD =,F8.1, 9H FEET/SEC,' (',F7.4, ' METERS/MSEC)',
     1          3X,7HGAMMA =,F7.3,I4,'  ITERATIONS')
 1125 FORMAT (/,2X,22HBURNED GAS COMPOSITION,/)
 1130 FORMAT ('0 THIS CASE TERMINATED BECAUSE THE LAST SET DID NOT CON
     1VERGE')
 1135 FORMAT (11X,18HCHAMBER PRESSURE =,F10.3,/)
 1140 FORMAT (11X,12HTEMPERATURE=,F10.3)
 1145 FORMAT (18H1TOO MANY ELEMENTS)
 1150 FORMAT (24H1ZERO MASS - CHECK INPUT)
 1155 FORMAT (   12A4,A4)
 1160 FORMAT (12X,12A4,A4)
 1165 FORMAT (1X,24HNO ELEMENT IN PROPELLANT)
1170  FORMAT(A3, E12.5      )
      END
      SUBROUTINE SETUP1
      COMMON/AZ/A(260,11),    IEVP(11),     NAMX2(260),   RTOTO,
     1          ANS(23),      IHEAD1(6),    NCHNG,        SCH,
     2          ATMOS,        IHEAD2(6),                  SPI,
     3          ATW,          IMBALA,       NCON,         SR(260),
     4          B(11),        INTIAL,       NCONV,        TANS(23),
     5          BMIN,         INTAPE,       NCTXP,        TANS1(23),
     6          CBAR,         ION,          NDET,         TANS2(23),
     7          CSTAR,        IOUTP,        NEQ,          TC,
     8          D,            ITE(6),       NGIN,         TIMES,
     9          DELPI,        ITER,         NKIN,         TO
      COMMON/BZ/DELPO,        ITT,          NKINC,        TOL,
     1          DELTO,        JLINED,       NLEL,         TOLMAX,
     2          DELXY,        K2,           NM,           TOLT,
     3          EL(23,24),    K3,           NMP,          U(260),
     4          ENTRPY,       LB,           NN,           Y(260),
     5          GAMACT,       LIBTP,        NN1,          YBAR,
     6          H(260),       LITER,        NNN,          YBC,
     7          HBAR,         LKDROP,       NP,           YC(260),
     8          HC,           LOUT,         NPRNT1,       YOUT(260,6),
     9          HI,           LV,           NSIN,         YR(260)
      COMMON/CZ/HR(260),      MAJOR,        NSYS,         Z(260,10),
     1          IDKIN(20),    MINOR,        NT,
     2          IDKINC(20),   MPD,          OUT(20,6),    IPART,
     3          IDSIN(260),   MPDP,         PC,
     4          IEV(11),      NAMX1(260),   R,            IEVN(11)
      COMMON/EZ/ NPN,             RLOT,  ZBAR,        ATWT(55),  WTG,
     1             CTRPT,GMFOUT(260,6)
      DIMENSION C(260),       SUMAAY(20),   YH(260),
     1          S(260),       SUMAYS(20),   YLN(260),      HS(260)
      DATA NCOUNT/0/
      IERR=0
      IF (NCTXP.EQ.5) GO TO 35
      IF (NCONV.EQ.0.AND.NCOUNT.LE.1) GO TO 370
      IF (NPRNT1.EQ.0) GO TO 5
      WRITE (IOUTP,425) ITER,TOL,TOLMAX,TOLT
      WRITE (IOUTP,435) (ANS(J),J=1,LV)
    5 NM1=NEQ+1
      NML=NEQ+NM
      NC1=NML+1
      IF (TO.LT.50.0) TO=50.0
      RTO=TO*1.98726
      RTOTO=TO*RTO
      CBAR=0.0
      HBAR=0.0
      LKDROP=LKDROP+1
      IMPLE=1
      TTO=TO/1000.0
      IF (ABS(ANS(K2)).GT.(.001*TO)) MAJOR=0
      IF (TO.LE.6000.0) GO TO 10
      IERR=1
      IMPLE=2
   10 IF (MAJOR.EQ.1) GO TO 15
      IF (ABS(TO-TCEN).GT.(0.1*TCEN)) IMPLE=2
      IF (ABS(TO-TPREV).GT.(.001*TCEN)) GO TO 15
      IF (IMBALA.EQ.1) GO TO 15
      IMPLE=3
      MAJOR=1
      TOL=0.1*TOLMAX
   15 IF (ITER.GT.1) GO TO 20
      IF (NCTXP.EQ.0.OR.NCTXP.EQ.4) IMPLE=3
   20 IF (LKDROP.EQ.8) IMPLE=3
      IF (NCONV.EQ.(-1)) GO TO 25
      IF (NCOUNT.LE.1) GO TO 25
      NCONV=-1
      IMPLE=3
   25 IF (IMPLE.EQ.3) LKDROP=0
      GO TO (30,35,35), IMPLE
   30 C1=TO-TPREV
      C2=ALOG(TO/TPREV)
      GO TO 50
   35 IF (TO-1200.0) 40,45,45
C
C           START SETUP OF COEFF. FOR UNDER 1200.0
C
   40 TSWTCH=-1.0
      C0=TO/1000.0
      C1=C0*C0
      C2=C0*C1
      C3=C0*C2
      C4=ALOG(C0)-0.18232
      C5=C0-1.2
      C6=0.5*(C1-1.44)
      C7=0.33333333*(C2-1.728)
      C8=0.25*(C3-2.0736)
      C9=.2*(C0*C3-2.48832)
      GO TO 50
C
C     END UNDER 1200.0 COEFF. SETUP   START OF OVER 1200.0 COEFF. SETUP
C
   45 TSWTCH=1.0
      IF (TO.GT.6000.) TO=6000.
      C0=1000.0/TO
      C1=C0*C0
      C2=C0*C1
      C3=C0*C2
      C4=(TO/1000.0)-1.2
      C5=ALOG(TO/1000.0)-0.18232
      C6=0.83333333-1000.0/TO
      C7=0.5*(0.69444444-C1)
      C8=0.33333333*(0.57870370-C2)
      C9=0.25*(0.48225308-C3)
C
C                   END OVER 1200.0 COEFFECIENT SETUP
C
   50 IRE=0
      IF (NCTXP.EQ.5) GO TO 55
      GO TO (125,125,55), IMPLE
C
C               FULL BLOWN SOLUTION FOR TOTAL NUMBER OF SPECIES
C               CONSIDERED.      IMPLE=3.
C
   55 ISTOP=NT
      GO TO 155
   60 IF (ITER.LT.1) GO TO 85
      BLOGAT=ALOG(ATMOS)
C
C               TEST FOR ADDING GASES TO THE SOLUTION.
C
      DO 70 I=1,NN
      IF (Y(I).GE.TOLT) GO TO 70
      IF (ION.NE.0.AND.A(I,NM).NE.0.0) GO TO 70
      SUMAPI=0.0
      DO 65 J=1,NM
      J1=J+NEQP
   65 SUMAPI=SUMAPI+ANS(J1)*A(I,J)
      EXPP=SUMAPI-BLOGAT-HS(I)
      IF( ABS(EXPP) .LT. 62.0 ) GO TO 64
      IF( EXPP ) 61,61, 62
61    EXPP = -62.0
      GO TO 64
62    EXPP = 62.0
64    CONTINUE
      Y(I)=YBAR*EXP(EXPP)
63    CONTINUE
      IF (Y(I).LT.TOL) GO TO 70
      Y(I)=TOL
      IRE=1
   70 CONTINUE
C
C               TEST FOR ADDING CONDENSIBLES TO THE SOLUTION.
C
      IF (NP.LE.0) GO TO 100
      DM=0.0
      NCOUNT=0
      DO 80 K=NN1,NT
      IF (Y(K).GT.0.0) GO TO 80
      SUMAPI=0.0
      DO 75 J=1,NM
      J1=J+NEQP
   75 SUMAPI=SUMAPI+ANS(J1)*A(K,J)
      DMT=SUMAPI-HS(K)
      IF (DMT.LE.DM) GO TO 80
      LR=K
      DM=DMT
      NCOUNT=NCOUNT+1
   80 CONTINUE
      IF (DM.LE.0.0) GO TO 85
      Y(LR)=0.0001
      IRE=1
C
C               COUNT THE NUMBER OF CONDENSIBLES IN THE SYSTEM.
C
   85 NKIN=0
      IF (NP.LT.1) GO TO 95
      DO 90 K=NN1,NT
      IF (Y(K).LE.0.0) GO TO 90
      NKIN=NKIN+1
      IDKIN(NKIN)=K
   90 CONTINUE
   95 IF (ITER.LT.1) GO TO 110
  100 IF (IRE.NE.0) GO TO 105
      IF (NCONV) 185,370,370
C
C               COUNT THE NUMBER OF GASES IN THE SYSTEM.
C
  105 NCONV=-1
  110 NGIN=0
      DO 120 I=1,NN
      IF (ION.NE.0.AND.A(I,NM).NE.0.0) GO TO 115
      IF (Y(I).LT.TOL) GO TO 120
  115 NGIN=NGIN+1
      IDSIN(NGIN)=I
  120 CONTINUE
C
C               COUNT THE NUMBER OF SPECIES IN FOR ALL IMPLE VALUES.
C
  125 NSIN=NGIN
      IF (NP.LE.0) GO TO 135
      J=0
      DO 130 I=NN1,NT
      IF (Y(I).LE.0.0) GO TO 130
      J=J+1
      NSIN=NSIN+1
      IDSIN(NSIN)=I
      IDKIN(J)=I
  130 CONTINUE
  135 LV=NML+NKIN
      LB=LV+1
      GO TO (140,150,185), IMPLE
C
C               QUICK CALCULATIONS OF H AND S FOR IMPLE=1.
C
  140 DO 145 J=1,NSIN
      I=IDSIN(J)
      H(I)=H(I)+C(I)*C1
      S(I)=S(I)+C(I)*C2
  145 HS(I)=(H(I)/RTO)-(S(I)/R)
      GO TO 185
C
C               CALCULATE H AND S FOR ONLY THE SPECIES IN THE
C               SOLUTION AT THE PRESENT TIME.  IMPLE=2.
C
  150 ISTOP=NSIN
C
C               CALCULATE H AND S FOR IMPLE=2 OR IMPLE=3.
C
  155 IF (TSWTCH) 160,170,170
  160 DO 165 J=1,ISTOP
      I=J
      IF (IMPLE.EQ.2) I=IDSIN(J)
      C(I)=Z(I,6)+Z(I,7)*C0+Z(I,8)*C1+Z(I,9)*C2+Z(I,10)*C3
      S(I)=SR(I)+Z(I,6)*C4+Z(I,7)*C5+Z(I,8)*C6+Z(I,9)*C7+Z(I,10)*C8
      H(I)=HR(I)+Z(I,6)*C5+Z(I,7)*C6+Z(I,8)*C7+Z(I,9)*C8+Z(I,10)*C9
      H(I)=1000.0*H(I)
      HS(I)=(H(I)/RTO)-(S(I)/R)
  165 CONTINUE
      GO TO 180
  170 DO 175 J=1,ISTOP
      I=J
      IF (IMPLE.EQ.2) I=IDSIN(J)
      C(I)=Z(I,1)+Z(I,2)*C0+Z(I,3)*C1+Z(I,4)*C2+Z(I,5)*C3
      S(I)=SR(I)+Z(I,1)*C5+Z(I,2)*C6+Z(I,3)*C7+Z(I,4)*C8+Z(I,5)*C9
      H(I)=HR(I)+Z(I,1)*C4+Z(I,2)*C5+Z(I,3)*C6+Z(I,4)*C7+Z(I,5)*C8
      H(I)=1000.0*H(I)
      HS(I)=(H(I)/RTO)-(S(I)/R)
      IF (IERR.EQ.0) GO TO 175
      H(I)=H(I)+C(I)*(TTO-6.)*1000.
      S(I)=S(I)+C(I)*ALOG(TTO/6.)
      HS(I)=(H(I)/RTO)-(S(I)/R)
  175 CONTINUE
  180 IF (NCTXP.EQ.5) GO TO 395
C
C               BRANCH BACK FOR IMPLE=3.
C
      IF (IMPLE.EQ.3) GO TO 60
C
C               ALL IMPLE'S WIND UP HERE SO CALCULATE THE REST
C               OF THE GARBAGE FOR EACH ITERATION.
C
  185 NEQP=NEQ
      TCEN=TO
  190 YBAR=0.0
      WTG = 0.0
      NMM = NM
      IF( ION .EQ. 1) NMM = NMM - 1
      DO 195 J=1,NGIN
      I=IDSIN(J)
      WM = 0.0
      DO 192 K = 1,NMM
      M = IEVN(K)
192   WM = WM + A(I,K)*ATWT(M)
      WTG = WTG + Y(I)*WM
  195 YBAR=YBAR+Y(I)
      PYLN=ALOG(ATMOS/YBAR)
      TOLT=TOL
      TO=TTO*1000.0
      SUMYU=0.0
      DO 200 J=1,NGIN
      I=IDSIN(J)
      CBAR=CBAR+C(I)*Y(I)
      YH(I)=Y(I)*H(I)
      HBAR=HBAR+YH(I)
      IF( Y(I) ) 196, 196, 197
196   YLN(I) = -1.0E-37
      GO TO 198
197   YLN(I)=ALOG(Y(I))
198   U(I)=HS(I)+PYLN+YLN(I)
  200 SUMYU=SUMYU+Y(I)*U(I)
      SUMYH=HBAR
      ZBAR = YBAR
      IF (NKIN.LT.1) GO TO 210
      N=NGIN+1
      DO 205 J=N,NSIN
      I=IDSIN(J)
      ZBAR=ZBAR+Y(I)
      CBAR=CBAR+C(I)*Y(I)
  205 HBAR=HBAR+H(I)*Y(I)
  210 IMBAL=0
C
C               PANIC PRINT.
C
      IF (NPRNT1.EQ.0) GO TO 225
      WRITE (IOUTP,450) NGIN,NKIN,NSIN
      WRITE (IOUTP,455) IMPLE,LV,LB,IRE
      WRITE (IOUTP,420) TO,YBAR,HBAR,CBAR
      WRITE (IOUTP,445)
      DO 215 J=1,NGIN
      I=IDSIN(J)
  215 WRITE (IOUTP,440) NAMX1(I),NAMX2(I),Y(I),YLN(I),C(I),H(I),S(I),U(I
     1),YR(I)
C
C               START SETTING UP THE ELEMENTS OF THE 'EL' ARRAY.
C
  225 DO 275 M=NM1,NML
      MT=M-NEQ
      SUMAY=0.0
      SUMAYH=0.0
      SUMAYU=0.0
      DO 230 K=1,MT
  230 SUMAAY(K)=0.0
      DO 240 J=1,NGIN
      I=IDSIN(J)
      AY=A(I,MT)*Y(I)
      IF (AY.EQ.0.0) GO TO 240
      SUMAY=SUMAY+AY
      SUMAYH=SUMAYH+AY*H(I)
      SUMAYU=SUMAYU+AY*U(I)
      DO 235 K=1,MT
  235 SUMAAY(K)=SUMAAY(K)+A(I,K)*AY
  240 CONTINUE
      IF (ION.EQ.1.AND.MT.EQ.NM) GO TO 265
      TSMAY=SUMAY
      DEN = TSMAY
      IF( ABS(DEN) .LT. 1.0E-25) DEN = 1.0
      BRAY = B(MT)/DEN
      IF (NP.LE.0.OR.NKIN.LE.0) GO TO 250
      DO 245 J=1,NKIN
      I=IDKIN(J)
  245 TSMAY=TSMAY+A(I,MT)*Y(I)
      DEN = TSMAY
      IF( ABS(DEN) .LT. 1.0E-25) DEN = 1.0
      BRAY = B(MT)/DEN
  250 IF ((TSMAY-B(MT)).LT.(.2*B(MT))) GO TO 265
      IMBAL=1
      IF (NPRNT1.EQ.0) GO TO 255
      WRITE (IOUTP,470) IMBAL,MT,B(MT),SUMAY,BRAY
  255 DO 260 J=1,NSIN
      I=IDSIN(J)
      IF (A(I,MT).EQ.(0.0)) GO TO 260
      Y(I)=BRAY*Y(I)
  260 CONTINUE
      GO TO 275
  265 EL(M,K3)=SUMAY
      EL(M,K2)=SUMAYH/RTOTO
      EL(M,LB)=B(MT)+SUMAYU
      DO 270 M1=NM1,M
      K=M1-NEQ
  270 EL(M,M1)=SUMAAY(K)
  275 CONTINUE
C
C               BRANCH BACK FOR ANY IMBALANCES.
C
      IF (IMBAL.EQ.1) GO TO 190
      EL(K3,K3)=0.0
      EL(K3,K2)=SUMYH/RTOTO
      EL(K3,LB)=SUMYU
      IF (NKIN) 310,310,280
C
C               CONDENSIBLES ONLY.
C
  280 DO 305 I=1,NKIN
      K=NML+I
      J=IDKIN(I)
      IF (NCTXP) 285,290,285
  285 EL(K2,K)=S(J)
  290 EL(K,K2)=H(J)/RTOTO
      EL(K,LB)=HS(J)
      EL(K,K3)=0.0
      DO 295 M=NM1,NML
      MT=M-NEQ
  295 EL(K,M)=A(J,MT)
      DO 300 KK=NC1,K
  300 EL(K,KK)=0.0
  305 CONTINUE
C
C               FLIP THE SMALL ARRAY.
C
  310 LVM1=LV-1
      DO 315 I=K3,LVM1
      DO 315 J=I,LVM1
  315 EL(I,J+1)=EL(J+1,I)
C
C               ALL SOLUTIONS EXCEPT THE CHAMBER.
C
      IF (NCTXP.EQ.0) GO TO 335
      SUMYS=0.0
      SUMYSH=0.0
      SUMYSU=0.0
      DO 320 M=1,NM
  320 SUMAYS(M)=0.0
      DO 325 J=1,NGIN
      I=IDSIN(J)
      YS=Y(I)*(S(I)-(R*YLN(I)))
      SUMYS=SUMYS+YS
      SUMYSH=SUMYSH+YS*H(I)
      SUMYSU=SUMYSU+YS*U(I)
      DO 325 M=1,NM
  325 SUMAYS(M)=SUMAYS(M)+A(I,M)*YS
      EL(K2,LB)=SCH+SUMYSU
      EL(K2,K3)=SUMYS-R*YBAR*PYLN
      EL(K2,K2)=CBAR/TO+SUMYSH/RTOTO
      DO 330 M=1,NM
      MT=M+NEQ
  330 EL(K2,MT)=SUMAYS(M)
C
C               CHAMBER AND AREA RATIO SOLUTIONS.
C
      IF (NCTXP.NE.3) GO TO 405
  335 SUMYHH=0.0
      SUMYHU=0.0
      DO 340 J=1,NGIN
      I=IDSIN(J)
      SUMYHH=SUMYHH+YH(I)*H(I)
  340 SUMYHU=SUMYHU+YH(I)*U(I)
C
C               CHAMBER SOLUTION ONLY.
C
      IF (NCTXP.EQ.3) GO TO 350
      DO 345 I=K3,LV
  345 EL(K2,I)=EL(I,K2)*RTOTO
      EL(K2,LB)=HI+SUMYHU
      EL(K2,K2)=CBAR+SUMYHH/RTOTO
      EL(K2,K3)=SUMYH
      GO TO 405
C
C               AREA RATIO SOLUTION ONLY.
C
  350 DH=HI-HBAR
      SRDH=SQRT(ABS(DH))
      IF (DH.LT.0.0) SRDH=-SRDH
      EL(1,2)=RTO*(2.0*DH-TO*CBAR)
      EL(1,LB)=HBAR+(2.0*D*DH*SRDH*ATMOS)/(.00089684*YBAR*TO)
      EL(1,2)=(EL(1,2)+SUMYHH)/RTOTO
      EL(1,LB)=EL(1,LB)+SUMYHU
      EL(1,3)=SUMYH+2.0*DH
      EL(1,1)=-EL(1,3)/ATMOS
      DO 355 M=NM1,NML
      EL(1,M)=EL(M,2)*RTOTO
  355 EL(M,1)=-EL(M,3)/ATMOS
      EL(2,1)=-(EL(2,3)+R*YBAR*(1.0+PYLN))/ATMOS
      EL(3,1)=-YBAR/ATMOS
      IF (NKIN) 405,405,360
  360 DO 365 I=1,NKIN
      K=NML+I
      J=IDKIN(I)
      EL(1,K)=H(J)
  365 EL(K,1)=0.0
      GO TO 405
C
C     GET ENTROPY SEEING AS WE HAVE REACHED CONVERGANCE
C
  370 ENTRPY=YBAR*R*ALOG(YBAR/ATMOS)
      YRYLNS=0.0
      DO 375 J=1,NGIN
      I=IDSIN(J)
      YRYLN=Y(I)*R*YLN(I)
      YRYLNS=YRYLNS+YRYLN
  375 ENTRPY=ENTRPY+Y(I)*S(I)-YRYLN
      IF (NCTXP.EQ.0) YRYLNC=YRYLNS
      IF (NKIN) 390,390,380
  380 DO 385 J=1,NKIN
      K=IDKIN(J)
  385 ENTRPY=ENTRPY+Y(K)*S(K)
  390 IF (NCTXP.EQ.0.OR.NCTXP.EQ.4) GO TO 405
      IF (ABS(ENTRPY-SCH).GT.0.002) NCONV=-1
      GO TO 405
C
C               FROZEN CALCULATION.
C
  395 ENTRPY=YBC*R*ALOG(YBC/ATMOS)-YRYLNC
      CBAR=0.0
      HBAR=0.0
      DO 400 I=1,NT
      CBAR=CBAR+C(I)*YC(I)
      HBAR=HBAR+H(I)*YC(I)
  400 ENTRPY=ENTRPY+YC(I)*S(I)
      ITER=ITER+1
      IF (ITER.GT.LITER) GO TO 405
      TPREV=TO
      TO=EXP((SCH-ENTRPY+CBAR*ALOG(TO))/CBAR)
      IF (ABS(TPREV-TO).GE.5.0) GO TO 35
      TO=TPREV
  405 TPREV=TO
C
C               PANIC PRINT OF THE 'EL' ARRAY.
C
      IF (NPRNT1.EQ.0) GO TO 415
      WRITE (IOUTP,430)
      DO 410 I=1,LV
  410 WRITE (IOUTP,435) (EL(I,J),J=1,LB)
  415 RETURN
C
C
  420 FORMAT (4H TO=F6.0,7H  YBAR=F6.4,7H  HBAR=F11.3,7H  CBAR=F6.3)
  425 FORMAT (6H1ITER=,I3,5H TOL=,F8.6,8H TOLMAX=,F8.6,6H TOLT=,F8.6)
  430 FORMAT (6H ARRAY)
  435 FORMAT (10(1X,F11.6))
  440 FORMAT (1X,2A4,3F8.4,F8.0,2F8.4,F10.4)
  445 FORMAT (5H0NAME,12X,1HY,6X,3HYLN,3X,1HC,7X,1HH,7X,1HS,4X,6HHS OR ,
     11HU)
  450 FORMAT (/,10X,6HNGIN =,I7,3X,6HNKIN =,I7,3X,6HNSIN =,I7,/)
  455 FORMAT (5X,7HIMPLE =,I5,5H LV =,I5,5H LB =,I5,6H IRE =,I5)
  460 FORMAT (10X,5HSETUP)
  465 FORMAT (4(1X,2A4,1H=,F9.5))
  470 FORMAT (1X,7H IMBAL=I2,4H MT=I3,3H B=F8.4,7H SUMAY=F8.4,6H BRAY=F8
     1.4)
      END
      SUBROUTINE EQUIL
      COMMON/AZ/A(260,11),    IEVP(11),     NAMX2(260),   RTOTO,
     1          ANS(23),      IHEAD1(6),    NCHNG,        SCH,
     2          ATMOS,        IHEAD2(6),                  SPI,
     3          ATW,          IMBALA,       NCON,         SR(260),
     4          B(11),        INTIAL,       NCONV,        TANS(23),
     5          BMIN,         INTAPE,       NCTXP,        TANS1(23),
     6          CBAR,         ION,          NDET,         TANS2(23),
     7          CSTAR,        IOUTP,        NEQ,          TC,
     8          D,            ITE(6),       NGIN,         TIMES,
     9          DELPI,        ITER,         NKIN,         TO
      COMMON/BZ/DELPO,        ITT,          NKINC,        TOL,
     1          DELTO,        JLINED,       NLEL,         TOLMAX,
     2          DELXY,        K2,           NM,           TOLT,
     3          EL(23,24),    K3,           NMP,          U(260),
     4          ENTRPY,       LB,           NN,           Y(260),
     5          GAMACT,       LIBTP,        NN1,          YBAR,
     6          H(260),       LITER,        NNN,          YBC,
     7          HBAR,         LKDROP,       NP,           YC(260),
     8          HC,           LOUT,         NPRNT1,       YOUT(260,6),
     9          HI,           LV,           NSIN,         YR(260)
      COMMON/CZ/HR(260),      MAJOR,        NSYS,         Z(260,10),
     1          IDKIN(20),    MINOR,        NT,
     2          IDKINC(20),   MPD,          OUT(20,6),    IPART,
     3          IDSIN(260),   MPDP,         PC,
     4          IEV(11),      NAMX1(260),   R,            IEVN(11)
      COMMON/EZ/ NPN,             RLOT,  ZBAR,        ATWT(55),  WTG,
     1             CTRPT,GMFOUT(260,6)
      DATA IBLANK/'    '/
      DATA ICHAM1,ICHAM2/' CHA', 'MBER'/
      DATA ITHRT1,ITHRT2/'THR(', 'SHF)'/
      DATA ISHFT1,ISHFT2/'EXH(', 'SHF)'/
      DATA IFRZN1,IFRZN2/'EXH(', 'FRZ)'/
      IF (NCTXP.EQ.5) GO TO 110
      TOLMAX=.0001
      IF (BMIN.LT..001) TOLMAX=.1*BMIN
      TOL=TOLMAX
      TOLT=1.1*TOL
      ITER=0
      IF (NCTXP-2) 5,5,10
    5 NEQ=2
      GO TO 25
   10 IF (NCTXP-4) 15,20,20
   15 NEQ=3
      GO TO 25
   20 NEQ=1
      K2=23
      GO TO 30
   25 K2=NEQ-1
   30 NM1=NEQ+1
      NML=NM+NEQ
      K3=NEQ
      NCONV=-1
   35 IF (ITER.GT.1.OR.NCTXP.NE.0.OR.NSYS.NE.1) GO TO 50
      IF (ITER-1) 45,40,50
   40 NEQ=2
      K2=1
      ANS(K2)=50.0
      NM1=3
      NML=NM+2
      K3=2
      NCONV=-1
      GO TO 50
   45 NEQ=1
      K2=23
      ANS(K2)=50.0
      NM1=2
      NML=NM+1
      K3=1
      NCONV=-1
   50 LV=NML+NKIN
      LB=LV+1
      CALL SETUP1
      CALL SLE
      NCONV=0
      CALL TOY
      ITER=ITER+1
      IF (ITER.GT.LITER) GO TO 55
      IF(NCONV.EQ.0)CALL SETUP1
      IF (NCONV.EQ.0) GO TO 55
      GO TO 35
   55 LOUT=LOUT+1
      CALL SETUP1
C
C      NOW WE DETERMINE IF THE SOLUTION STRADDLES A PHASE TRANSITION
C      MAKING USE OF THE FACT THAT A SOLID+LIQUID PAIR HAS THE
C       SAME FORMULA
C
      MPDP=MPD
      MPD=0
      IF (NKIN.LE.0) GO TO 90
      IF (NKIN.LT.NM) GO TO 60
      MPD=1
      GO TO 90
   60 DO 80 I=1,NKIN
      IF (I-NKIN) 65,85,85
   65 IP1=I+1
      IDKINI=IDKIN(I)
      DO 75 J=IP1,NKIN
      IDKINJ=IDKIN(J)
      DO 70 K=1,NM
      IF (A(IDKINI,K)-A(IDKINJ,K)) 75,70,75
   70 CONTINUE
      MPD=1
      GO TO 85
   75 CONTINUE
   80 CONTINUE
   85 CONTINUE
C
C               CHAMBER AND TEMPERATURE SOLUTIONS.
C               SAVE THE CHAMBER SOLUTION FOR INTIAL CONDITIONS ON
C               THE NEXT PROBLEM.
C
   90 IF (NCTXP.NE.0.AND.NCTXP.NE.4) GO TO 115
      TC=TO
      PC=ATMOS
      HC=HBAR
      CBC=CBAR
      YBC=YBAR
      EPSLON=0.0
      SPI=0.0
      SCH=ENTRPY
      IHEAD1(LOUT)=ICHAM1
      IHEAD2(LOUT)=ICHAM2
      IF (NCTXP.NE.4) GO TO 95
      IHEAD1(LOUT)=IBLANK
      IHEAD2(LOUT)=IBLANK
   95 IF (INTIAL.EQ.1) GO TO 140
      DO 100 I=1,NT
  100 YC(I)=Y(I)
      NKINC=NKIN
      IF(NKIN.LE.0) GO TO 140
      DO 105 I=1,NKIN
  105 IDKINC(I)=IDKIN(I)
      GO TO 140
C
C               FROZEN CALCULATION DONE IN SETUP.
C
  110 ITER=0
      CALL SETUP1
      LOUT=LOUT+1
C
C               FINAL CALCULATIONS AND STORAGE IN THE 'OUT' ARRAY.
C
  115 continue
      hchbar=hc-hbar                            ! MWB mod to protect neg sqrt
      if(hchbar.le.0.0)  hchbar=0.001           ! MWB mod
c 115 SPI=0.933*SQRT(HC-HBAR)
      SPI=0.933*SQRT(hchbar)                    ! MWB mod
      IHEAD1(LOUT)=ISHFT1
      IHEAD2(LOUT)=ISHFT2
      IF (NCTXP.NE.5) GO TO 120
      IHEAD1(LOUT)=IFRZN1
      IHEAD2(LOUT)=IFRZN2
  120 IF (NCTXP.NE.2) GO TO 125
      CSTAR=27.816*PC*YBAR*TO/(SPI*ATMOS)
      OUT(20,3)=CSTAR
c     ATW=.00089684*YBAR*TO/(SQRT(HC-HBAR)*ATMOS)
      ATW=.00089684*YBAR*TO/(SQRT(hchbar)*ATMOS)           ! MWB mod
      IHEAD1(LOUT)=ITHRT1
      IHEAD2(LOUT)=ITHRT2
  125 CONTINUE
  140 PSI=14.696*ATMOS
      OUT(1,LOUT)=PSI
      OUT(2,LOUT)=SPI
      OUT(3,LOUT)=TO
      OUT(4,LOUT)=100.0/ZBAR
      OUT(5,LOUT)=YBAR
      OUT(6,LOUT)=CBAR/(CBAR-1.98726*YBAR)
      OUT(7,LOUT)=ENTRPY
      OUT(8,LOUT)=HBAR/1000.0
      OUT(9,LOUT) = WTG/YBAR
      OUT(10,LOUT) = PSI/(0.193*TO*YBAR)
      OUT(14,LOUT)=ATMOS/(YBAR*TO*.82057)
      ITE(LOUT)=ITER
C
C               EXHAUST PRODUCTS STORED IN 'YOUT'.
C
      IF (NCTXP.NE.5) GO TO 150
      DO 145 I=1,NT
  145 Y(I)=YC(I)
  150 IF (IPART.EQ.0) GO TO 160
      DO 155 I=1,NT
  155 YOUT(I,LOUT)=Y(I)*OUT(14,LOUT)*6.02252E+25
      RETURN
  160 DO 165 I=1,NT
  165 YOUT(I,LOUT)=Y(I)
      DO 170 I=1,NN
  170 GMFOUT(I,LOUT)=Y(I)/YBAR
      RETURN
      END
      SUBROUTINE CLOCK(X)
      CHARACTER *8 X1
      CALL TIME(X1)
      DECODE(10,10,X1) IH, IM, IS
10    FORMAT(I2, 1X, I2, 1X, I2)
      X = IS + 60*(IM + 60*IH)
      RETURN
C
      END
      SUBROUTINE INTDAT
      COMMON/DATINT/KDATE(3)
      DIMENSION X(3)
      CALL DATE_AND_TIME
C      DECODE(9,15,X)KDATE(2),KDATE(1),KDATE(3)
C   15 FORMAT(I2,1X,A3,1X,I2)
      RETURN
      END
      SUBROUTINE UNLOAD(I)
      REWIND I
      RETURN
      END
      SUBROUTINE XDATA
      LOGICAL FLAG,JTEST
      COMMON/AZ/A(260,11),    IEVP(11),     NAMX2(260),   RTOTO,
     1          ANS(23),      IHEAD1(6),    NCHNG,        SCH,
     2          ATMOS,        IHEAD2(6),                  SPI,
     3          ATW,          IMBALA,       NCON,         SR(260),
     4          B(11),        INTIAL,       NCONV,        TANS(23),
     5          BMIN,         INTAPE,       NCTXP,        TANS1(23),
     6          CBAR,         ION,          NDET,         TANS2(23),
     7          CSTAR,        IOUTP,        NEQ,          TC,
     8          D,            ITE(6),       NGIN,         TIMES,
     9          DELPI,        ITER,         NKIN,         TO
      COMMON/BZ/DELPO,        ITT,          NKINC,        TOL,
     1          DELTO,        JLINED,       NLEL,         TOLMAX,
     2          DELXY,        K2,           NM,           TOLT,
     3          EL(23,24),    K3,           NMP,          U(260),
     4          ENTRPY,       LB,           NN,           Y(260),
     5          GAMACT,       LIBTP,        NN1,          YBAR,
     6          H(260),       LITER,        NNN,          YBC,
     7          HBAR,         LKDROP,       NP,           YC(260),
     8          HC,           LOUT,         NPRNT1,       YOUT(260,6),
     9          HI,           LV,           NSIN,         YR(260)
      COMMON/CZ/HR(260),      MAJOR,        NSYS,         Z(260,10),
     1          IDKIN(20),    MINOR,        NT,
     2          IDKINC(20),   MPD,          OUT(20,6),    IPART,
     3          IDSIN(260),   MPDP,         PC,
     4          IEV(11),      NAMX1(260),   R,            IEVN(11)
      COMMON/EZ/ NPN,             RLOT,  ZBAR,        ATWT(55),  WTG,
     1             CTRPT,GMFOUT(260,6)
      COMMON/LBT/ LIBTP2
      DIMENSION IA(4),                      QA(4),        ZIN(10)
      DIMENSION NAMEM(260,4),QEM(260,4),KCHARG(260),IMPT(260)
      EQUIVALENCE (A(1,1),NAMEM(1,1)),(A(1,5),QEM(1,1)),
     1(YC(1),KCHARG(1)),(Y(1),IMPT(1))
      DATA ITESTE/2H E/
C
C               'JTEST' IS TESTED TO SEE IF ALL MODIFICATIONS
C               HAVE BEEN MADE IN ORDER TO SPEED UP THE JOB.
C
      FLAG=.FALSE.
      JTEST=.TRUE.
      MAXMUM=260
      IF (NCON.EQ.99) NCON=0
      IF (NCON.EQ.66) NCON=88
      IF (NCON.NE.88) WRITE (IOUTP,230)
      JNUM=0
      IF (MINOR.EQ.(-1)) MINOR=0
    5 IF (NCHNG.EQ.MAXMUM) GO TO 25
C
C               TEST MODIFICATION AND RESET IMPORTANCE CODE IF
C               SPECIE NOT IN THE SYSTEM.
C
      ISTART=NCHNG+1
      DO 20 I=ISTART,MAXMUM
      DO 15 J=1,4
      IF (QEM(I,J).EQ.0.0) GO TO 20
      IDSIN(I)=J
      DO 10 K=1,NM
      IF (IEV(K).EQ.NAMEM(I,J)) GO TO 15
   10 CONTINUE
      IMPT(I)=IMPT(I)+100
      GO TO 20
   15 CONTINUE
   20 CONTINUE
      JTEST=.FALSE.
   25 IF (MINOR.EQ.0) GO TO 30
      IF (NCON.NE.88) WRITE (IOUTP,235)
      JNUM=JNUM+1
   30 IF (NT.LE.0) GO TO 40
      READ (LIBTP) NLE
      DO 35 I=1,NLE
   35 READ (LIBTP) DUMMY
   40 NT=0
      READ (LIBTP) NGAS,NSPEC
      NGAS1=NGAS+1
C
C               START THE LOOP.
C
      DO 195 INTRY=1,NSPEC
      IF (NGAS1.EQ.INTRY) NN=NT
C
C               READ ONE SPECIE FROM TAPE.
C
      READ (LIBTP) (IA(J),QA(J),J=1,4),ICHARG,NY,NE,HRI,SRI,NAMEX1,NAMEX
     12,(ZIN(J),J=1,5),IDOW,(ZIN(J),J=6,10)
C
C               SKIP IONIZED SPECIES.
C
      IF (ION.EQ.0.AND.ICHARG.NE.0) GO TO 175
      IF (IA(1).EQ.ITESTE) GO TO 55
C
C               TEST TO SEE IF PRODUCT HAS CORRECT ELEMENTS.
C
      DO 50 J=1,NE
      DO 45 K=1,NM
      IF (IEV(K).EQ.IA(J)) GO TO 50
   45 CONTINUE
      GO TO 175
   50 CONTINUE
C
C               SPECIE ACCEPTED.
C
   55 NT=NT+1
      IF (NT.LE.NCHNG) GO TO 65
C
C               MORE THAN 260 SPECIES.
C               SUPPRESS MINOR EXHAUST SPECIES.
C
      REWIND LIBTP
      OPEN (UNIT=LIBTP, FILE='EDCONV.DAT',
     X     FORM = 'UNFORMATTED',TYPE='OLD')
      JNUM=2
      IF (MINOR.NE.0) GO TO 60
      WRITE (IOUTP,240)
      WRITE (IOUTP,245)
      MINOR=-1
      IF (NCON.EQ.88) NCON=77
      IF (NCHNG.EQ.MAXMUM) GO TO 5
      DO 56 I=ISTART,MAXMUM
         IF (IMPT(I).GE.100) IMPT(I)=IMPT(I)-100
   56 CONTINUE
      GO TO 5
C
C               STILL MORE.
C               RETURN AND SKIP INPUT.
C
   60 WRITE (IOUTP,240)
      WRITE (IOUTP,250)
      IF (NCON.EQ.77) NCON=66
      IF (NCON.NE.66) NCON=99
      NT=NCHNG
      GO TO 210
C
C               SKIP MINOR SPECIES.
C
   65 IF (ICHARG.NE.0) GO TO 70
      IF (MINOR.NE.0.AND.NY.EQ.30) GO TO 165
   70 IF (FLAG) GO TO 100
C
C               SPECIE ACCEPTED.
C
      NAMX1(NT)=NAMEX1
      NAMX2(NT)=NAMEX2
      SR(NT)=SRI
      HR(NT)=HRI
      DO 75 J=1,10
   75    Z(NT,J)=ZIN(J)
C
C               TEST FOR MODIFICATIONS.
C
      IF (NCHNG.EQ.MAXMUM) GO TO 110
      IF (JTEST) GO TO 110
      JTEST=.TRUE.
      DO 95 I=ISTART,MAXMUM
      IF (IMPT(I).GE.100) GO TO 95
      JTEST=.FALSE.
      IF (IDSIN(I).NE.NE) GO TO 95
      L=I
      DO 90 K=1,NE
      DO 80 J=1,NE
      IF (IA(K).EQ.NAMEM(I,J)) GO TO 85
   80 CONTINUE
      GO TO 95
   85 IF (QA(K).NE.QEM(I,J)) GO TO 95
   90 CONTINUE
      IF (ICHARG.NE.KCHARG(I)) GO TO 95
      IF (IMPT(I).LT.50.AND.NY.LT.50) GO TO 100
      KSTEST=IMPT(I)
      NYTEST=NY
      IF (KSTEST.GE.80) KSTEST=KSTEST-5
      IF (NY.GE.80) NYTEST=NY-5
      IF (KSTEST.EQ.NYTEST) GO TO 100
   95 CONTINUE
      GO TO 110
C
C               MODIFY SPECIE.
C
  100 NY=IMPT(L)
      IMPT(L)=IMPT(L)+100
      IF (HR(L).LE.(-1.0E10)) GO TO 165
      HR(NT)=HR(L)
      IF (SR(L).LE.(-1.0E10)) GO TO 110
      SR(NT)=SR(L)
      NAMX1(NT)=NAMX1(L)
      NAMX2(NT)=NAMX2(L)
      ICHARG=KCHARG(L)
      DO 105 J=1,10
  105 Z(NT,J)=Z(L,J)
C
C               INITIALIZE AMOUNT OF SPECIE DEPENDING UPON
C               IMPORTANCE.
C
  110 IGO=NY/10+1
      GO TO (115,120,125,130,135,135,135,135,125), IGO
  115 Y(NT)=1.0
      GO TO 140
  120 Y(NT)=.1
      GO TO 140
  125 Y(NT)=.01
      GO TO 140
  130 Y(NT)=.000001
      GO TO 140
  135 Y(NT)=0.0
C
C               SET UP 'A' MATRIX FOR AMOUNT OF EACH ELEMENT
C               OF THE SPECIE.
C
  140 DO 145 NM1=1,NM
  145 A(NT,NM1)=0.0
      DO 160 NE1=1,NE
      DO 150 NM1=1,NM
      IF (IEV(NM1).EQ.IA(NE1)) GO TO 155
  150 CONTINUE
      GO TO 160
  155 A(NT,NM1)=QA(NE1)
  160 CONTINUE
      IF (ION.NE.0) A(NT,NM+1)=ICHARG
      GO TO 175
C
C               SPECIES SUPPRESSED.
C
  165 IF (JNUM.EQ.0) WRITE (IOUTP,235)
      IF (NCON.NE.88) WRITE (IOUTP,260) NAMEX1,NAMEX2
      JNUM=JNUM+1
      IF (JNUM.LT.40) GO TO 170
         IF (NCON.NE.88) WRITE (IOUTP,230)
         JNUM=1
  170 NT=NT-1
C
C               SET UP FOR POSSIBLE SPECIE TO BE ADDED.
C
  175 IF (NCHNG.EQ.MAXMUM) GO TO 195
      IF (JTEST) GO TO 195
      IF (INTRY.NE.NGAS.AND.INTRY.NE.NSPEC) GO TO 195
      FLAG=.TRUE.
      DO 190 J=ISTART,MAXMUM
      IF (SR(J).LE.(-1.0E10)) GO TO 190
      IF (IMPT(J).GE.100) GO TO 190
      IF (INTRY.EQ.NGAS.AND.IMPT(J).GT.50) GO TO 190
      ICHARG=KCHARG(J)
      IF (ION.EQ.0.AND.ICHARG.NE.0) GO TO 185
      L=J
      NE=IDSIN(L)
      DO 180 I=1,NE
      QA(I)=QEM(L,I)
  180 IA(I)=NAMEM(L,I)
      GO TO 55
  185 IMPT(J)=IMPT(J)+100
  190 CONTINUE
      FLAG=.FALSE.
  195 CONTINUE
C
C               INITIALIZE FOR NEXT CALL.
C
      IF (NCHNG.EQ.MAXMUM) GO TO 205
      DO 200 J=ISTART,MAXMUM
  200 IMPT(J)=IMPT(J)-100
  205 NN1=NN+1
      NP=NT-NN
  210 NMP=NM
      DO 215 I=1,NM
  215    IEVP(I)=IEV(I)
      IF (NCON.NE.88) WRITE (IOUTP,255)
  255 FORMAT (22H0   SPECIES CONSIDERED)
      JNUM=JNUM+2
C
C               SPECIES CONSIDERED.
C
      DO 225 I=1,NT
         IF (JNUM.LT.40) GO TO 220
            IF (NCON.NE.88) WRITE (IOUTP,230)
            JNUM=0
  220    IF (NCON.NE.88)
     X       WRITE (IOUTP,260) NAMX1(I),NAMX2(I),HR(I),SR(I)
         JNUM=JNUM+1
  225 CONTINUE
      REWIND LIBTP
      OPEN (UNIT=LIBTP, FILE='EDCONV.DAT',
     X       FORM = 'UNFORMATTED',TYPE='OLD')
      IF (NCON.EQ.77) NCON=88
      RETURN
C
C
  230 FORMAT (1H1)
  235 FORMAT (4X,18HSPECIES SUPPRESSED)
  240 FORMAT (62H1MORE SPECIES WERE CONSIDERED THAN ALLOWED FOR BY THE P
     1ROGRAM.)
  245 FORMAT (42H THE SPECIES SUPPRESSED FLAG HAS BEEN SET.)
  250 FORMAT (28H THIS PROBLEM IS TERMINATED.)
  260 FORMAT (2X,2A4,2F9.3)
      END
      SUBROUTINE OUTPUT
      COMMON/AZ/A(260,11),    IEVP(11),     NAMX2(260),   RTOTO,
     1          ANS(23),      IHEAD1(6),    NCHNG,        SCH,
     2          ATMOS,        IHEAD2(6),                  SPI,
     3          ATW,          IMBALA,       NCON,         SR(260),
     4          B(11),        INTIAL,       NCONV,        TANS(23),
     5          BMIN,         INTAPE,       NCTXP,        TANS1(23),
     6          CBAR,         ION,          NDET,         TANS2(23),
     7          CSTAR,        IOUTP,        NEQ,          TC,
     8          D,            ITE(6),       NGIN,         TIMES,
     9          DELPI,        ITER,         NKIN,         TO
      COMMON/BZ/DELPO,        ITT,          NKINC,        TOL,
     1          DELTO,        JLINED,       NLEL,         TOLMAX,
     2          DELXY,        K2,           NM,           TOLT,
     3          EL(23,24),    K3,           NMP,          U(260),
     4          ENTRPY,       LB,           NN,           Y(260),
     5          GAMACT,       LIBTP,        NN1,          YBAR,
     6          H(260),       LITER,        NNN,          YBC,
     7          HBAR,         LKDROP,       NP,           YC(260),
     8          HC,           LOUT,         NPRNT1,       YOUT(260,6),
     9          HI,           LV,           NSIN,         YR(260)
      COMMON/CZ/HR(260),      MAJOR,        NSYS,         Z(260,10),
     1          IDKIN(20),    MINOR,        NT,
     2          IDKINC(20),   MPD,          OUT(20,6),    IPART,
     3          IDSIN(260),   MPDP,         PC,
     4          IEV(11),      NAMX1(260),   R,          IEVN(11)
      COMMON/EZ/ NPN,             RLOT,  ZBAR,         ATWT(55),  WTG,
     1           CTRPT,GMFOUT(260,6)
      DIMENSION JTITLE(6,3)
      DIMENSION ITITLE(15,3), LTITLE(3),    MTITLE(3),MFTITL(3)
      CHARACTER *5 ITITLE,JTITLE,LTITLE,MTITLE,MFTITL
      DATA ITITLE(1,1),ITITLE(1,2),ITITLE(1,3)
     1/' PRES', 'SURE(', 'PSIA)'/
      DATA ITITLE(2,1),ITITLE(2,2),ITITLE(2,3)
     1/' ISP', '  ', '  '/
      DATA ITITLE(3,1),ITITLE(3,2),ITITLE(3,3)
     1/' TEMP', 'ERATU', 'RE(K)'/
      DATA ITITLE(4,1),ITITLE(4,2),ITITLE(4,3)
     1/' MOLE', 'CULAR', ' WGT'/
      DATA ITITLE(5,1),ITITLE(5,2),ITITLE(5,3)
     1/' MOLE', 'S GAS', '/100G'/
      DATA ITITLE(6,1),ITITLE(6,2),ITITLE(6,3)
     1/' GAMM', 'A', ' '/
      DATA ITITLE(7,1),ITITLE(7,2),ITITLE(7,3)
     1/ ' ENTR', 'OPY (', ' "  )'/
      DATA ITITLE(8,1),ITITLE(8,2),ITITLE(8,3)
     1/' ENTH', ' KCAL', '/100G'/
      DATA (ITITLE(9,I), I=1,3)
     1/' GAS ', ' MOL ', 'WT'/
      DATA (ITITLE(10,I), I=1,3)
     1/' RHO ', 'PROD(', '#/F3)'/
      DATA ITITLE(14,1),ITITLE(14,2),ITITLE(14,3)
     1/' DENS', 'ITY (', 'G/CC)'/
      DATA ITITLE(15,1),ITITLE(15,2),ITITLE(15,3)
     1/' ITER', 'ATION', 'S'/
      DATA (LTITLE(I), I=1,3 )
     1/' PART', 'ICLES', '/CC'/
      DATA(MTITLE(I),I=1,3)
     1/' MOLE', 'S/100', ' GRAM'/
      DATA(MFTITL(I),I=1,3)
     1/' GAS ', 'MOLE ', 'FRACS'/
      DATA(jTITLe(4,I),I=1,3)
     1/' cp-g ', '  c/1', '00g-K'/
C
C
      IF (NCON.EQ.88) GO TO 55
      LINE=6+NM
      IF (NDET.GT.0) LINE=JLINED-2
      IF (NDET.GT.0) GO TO 10
      WRITE (IOUTP,100) (IHEAD1(I),IHEAD2(I),I=1,LOUT)
      LINE=LINE+1
      DO 5 J=1,10
         WRITE (IOUTP,80) (ITITLE(J,I),I=1,3),(OUT(J,I),I=1,LOUT)
5     CONTINUE
C      WRITE (IOUTP,95) (ITITLE(14,I),I=1,3),(OUT(14,I),I=1,LOUT)
      DO 6 J=4,4
         WRITE (IOUTP,80) (jTITLE(J,I),I=1,3),(OUT(J,I),I=1,LOUT)
6     CONTINUE
      WRITE (IOUTP,85) (ITITLE(15,I),I=1,3),(ITE(I),I=1,LOUT)
      WRITE (IOUTP,75)
   10 LINE=LINE+21
      IF (IPART.EQ.1) WRITE (IOUTP,80) LTITLE
      IF (IPART.EQ.0) WRITE (IOUTP,80) MTITLE
      WRITE (IOUTP,75)
      DO 50 I=1,NT
      IF (LINE.LT.40) GO TO 15
      WRITE (IOUTP,65)
      LINE=0
   15 DO 35 J=1,LOUT
         IF (YOUT(I,J)-CTRPT   ) 35,40,40
   35 CONTINUE
      GO TO 50
   40 WRITE (IOUTP,75) NAMX1(I),NAMX2(I),(YOUT(I,J),J=1,LOUT)
      LINE=LINE+1
   50 CONTINUE
C
C                  GAS MOLE FRACTIONS OUT
C
      IF (IPART.NE.0) GO TO 150
      WRITE (IOUTP,75)
      WRITE (IOUTP,80) MFTITL
      WRITE (IOUTP,75)
      LINE = LINE + 3
      DO 150 I=1,NN
      IF (LINE.LT.40) GO TO 115
      WRITE (IOUTP,65)
      LINE=0
  115 DO 135 J=1,LOUT
         IF (YOUT(I,J)-CTRPT   ) 135,140,140
  135 CONTINUE
      GO TO 150
  140 WRITE (IOUTP,75) NAMX1(I),NAMX2(I),(GMFOUT(I,J),J=1,LOUT)
      LINE=LINE+1
  150 CONTINUE
C
C                  SYSTEM ROUTINE TO RETURN THE TIME IN SECONDS.
C                  SEE STATEMENT NUMBER 580 IN 'MAIN'.
C
      CALL CLOCK (TIMEE)
C
      TIMEE=TIMEE-TIMES
      WRITE (IOUTP,70) TIMEE
   55 LOUT=0
      RETURN
C
C
   65 FORMAT (1H1)
   70 FORMAT (50X,10HSECONDS = ,F10.4)
   75 FORMAT (1X,2A4,6X,6F14.6)
   80 FORMAT (3A5,6F14.3)
   85 FORMAT (3A5,6I14)
   95 FORMAT (3A5,1P6E14.5)
  100 FORMAT (18X,6(4X,2A4))
      END
      SUBROUTINE TOY
      COMMON/AZ/A(260,11),    IEVP(11),     NAMX2(260),   RTOTO,
     1          ANS(23),      IHEAD1(6),    NCHNG,        SCH,
     2          ATMOS,        IHEAD2(6),                  SPI,
     3          ATW,          IMBALA,       NCON,         SR(260),
     4          B(11),        INTIAL,       NCONV,        TANS(23),
     5          BMIN,         INTAPE,       NCTXP,        TANS1(23),
     6          CBAR,         ION,          NDET,         TANS2(23),
     7          CSTAR,        IOUTP,        NEQ,          TC,
     8          D,            ITE(6),       NGIN,         TIMES,
     9          DELPI,        ITER,         NKIN,         TO
      COMMON/BZ/DELPO,        ITT,          NKINC,        TOL,
     1          DELTO,        JLINED,       NLEL,         TOLMAX,
     2          DELXY,        K2,           NM,           TOLT,
     3          EL(23,24),    K3,           NMP,          U(260),
     4          ENTRPY,       LB,           NN,           Y(260),
     5          GAMACT,       LIBTP,        NN1,          YBAR,
     6          H(260),       LITER,        NNN,          YBC,
     7          HBAR,         LKDROP,       NP,           YC(260),
     8          HC,           LOUT,         NPRNT1,       YOUT(260,6),
     9          HI,           LV,           NSIN,         YR(260)
      COMMON/CZ/HR(260),      MAJOR,        NSYS,         Z(260,10),
     1          IDKIN(20),    MINOR,        NT,
     2          IDKINC(20),   MPD,          OUT(20,6),    IPART,
     3          IDSIN(260),   MPDP,         PC,
     4          IEV(11),      NAMX1(260),   R,          IEVN(11)
      SLIMIT = 1.0E-30
      NKINT=NKIN
      KINSM=-1
      SMLRA=1.0
      AK=ANS(K2)/RTOTO
      PMPO=0.0
      RPMPA=0.0
      IF (NEQ.EQ.1) ANS(K2)=0.0
      IF (NCTXP.NE.3) GO TO 25
      RPMPA=ANS(1)/ATMOS
      IF (ABS(ANS(1))-.5*ATMOS) 20,20,5
    5 IF (ANS(1)) 10,20,15
   10 PMPO=-.5*ATMOS
      GO TO 25
   15 PMPO=.5*ATMOS
      GO TO 25
   20 PMPO=ANS(1)
   25 RAT=ANS(K2)/TO
      IF (ABS(RAT).LT.(0.09)) GO TO 40
      IF (RAT) 30,40,35
   30 ANS(K2)=TO*(-0.09)
      GO TO 40
   35 ANS(K2)=0.09*TO
C
C                  FIND THE LARGEST SMALL RATIO FOR GASES.
C
   40 DO 50 KK=1,NGIN
      I=IDSIN(KK)
      SUMAPI=0.0
      DO 45 J=1,NM
      J1=J+NEQ
   45 SUMAPI=SUMAPI+ANS(J1)*A(I,J)
      YR(I)=ANS(K3)-U(I)+SUMAPI+AK*H(I)-RPMPA
      IF( YR(I) .GT. 0.0 .OR. Y(I) .LE. SLIMIT) GO TO 50
      IMBALA=1
      SMLRAT=.99/(1.0-YR(I))
      IF (SMLRAT.GE.SMLRA) GO TO 50
      SMLRA=SMLRAT
   50 CONTINUE
C
C                  FIND THE LARGEST SMALL RATIO FOR CONDENSIBLES.
C
      IF (NP.LE.0.OR.NKIN.LE.0) GO TO 60
      DO 55 KIN=1,NKIN
      K=IDKIN(KIN)
      M=KIN+NEQ+NM
      IF (ANS(M).GT.0.0) GO TO 55
      SMLRAT=Y(K)/(Y(K)-ANS(M))
      IF (SMLRAT.GE.SMLRA) GO TO 55
      KINSM=KIN
      SMLRA=SMLRAT
   55 CONTINUE
C
C                  RATIO NEW MOLES FOR GASES.
C
   60 JJ=0
      DO 70 KK=1,NGIN
      I=IDSIN(KK)
      Y(I)=Y(I)*(1.0+SMLRA*(YR(I)-1.0))
      IF (Y(I).GE.TOL) GO TO 65
      IF( ION .NE. 0 .AND. A(I,NM) .NE. 0.0 .AND. Y(I) .GE. SLIMIT)
     1             GO TO 65
C
C                  DROP THE GAS SPECIE FROM SOLUTION.
C
      Y(I)=0.0
      GO TO 70
   65 JJ=JJ+1
      IDSIN(JJ)=I
   70 CONTINUE
      NGIN=JJ
      IF (JJ.EQ.0) NGIN=1
C
C                  RATIO NEW MOLES FOR CONDENSIBLES.
C
      IF (NP.LE.0) GO TO 80
      IF (NKIN.LE.0) GO TO 80
      DO 75 KIN=1,NKIN
      K=IDKIN(KIN)
      M=KIN+NEQ+NM
      Y(K)=Y(K)+SMLRA*(ANS(M)-Y(K))
      IF (KIN.NE.KINSM) GO TO 75
C
C                  DROP THE CONDENSIBLE SPECIE FROM SOLUTION.
C
      IMBALA=1
      NKINT=NKIN-1
      NCONV=-1
      Y(K)=0.0
   75 CONTINUE
      NKIN=NKINT
   80 I1=NEQ+1
      I2=I1+NM-1+NKIN
C
C                  PANIC PRINT OF CONDENSIBLES.
C
      IF (NPRNT1.NE.1) GO TO 85
      WRITE (IOUTP,120)
      WRITE (IOUTP,125) (NAMX1(K),Y(K),K=NN1,NT)
   85 DO 100 I=I1,I2
      IF (ABS(TANS(I)-ANS(I))-DELPI) 95,90,90
   90 NCONV=-1
   95 TANS2(I)=TANS1(I)
      TANS1(I)=TANS(I)
  100 TANS(I)=ANS(I)
C
C                  CONVERGENCE CRITERIA TESTS.
C
      IF (MAJOR.EQ.0) GO TO 105
      IF (ABS(ANS(K2)).GE.DELTO) GO TO 105
      IF (ABS(ANS(K3)-1.0).GE.DELXY) GO TO 105
      IF (NEQ.NE.3) GO TO 110
      IF (ABS(ANS(1))-DELPO) 110,105,105
  105 NCONV=-1
  110 TO=TO+ANS(K2)
      ATMOS=ATMOS+PMPO
      IMBALA=0
      IF (NCTXP.NE.1.OR.NCTXP.NE.3) GO TO 115
      IF (TO.LT.0.0) TO=0.002
      IF (ATMOS.LT.0.0) ATMOS=0.02
  115 RETURN
C
C
  120 FORMAT (10X,3HTOY)
  125 FORMAT (8(1X,A4,1H=,F8.5))
      END
      SUBROUTINE SLE
      COMMON/AZ/A(260,11),    IEVP(11),     NAMX2(260),   RTOTO,
     1          ANS(23),      IHEAD1(6),    NCHNG,        SCH,
     2          ATMOS,        IHEAD2(6),                  SPI,
     3          ATW,          IMBALA,       NCON,         SR(260),
     4          B(11),        INTIAL,       NCONV,        TANS(23),
     5          BMIN,         INTAPE,       NCTXP,        TANS1(23),
     6          CBAR,         ION,          NDET,         TANS2(23),
     7          CSTAR,        IOUTP,        NEQ,          TC,
     8          D,            ITE(6),       NGIN,         TIMES,
     9          DELPI,        ITER,         NKIN,         TO
      COMMON/BZ/DELPO,        ITT,          NKINC,        TOL,
     1          DELTO,        JLINED,       NLEL,         TOLMAX,
     2          DELXY,        K2,           NM,           TOLT,
     3          EL(23,24),    K3,           NMP,          U(260),
     4          ENTRPY,       LB,           NN,           Y(260),
     5          GAMACT,       LIBTP,        NN1,          YBAR,
     6          H(260),       LITER,        NNN,          YBC,
     7          HBAR,         LKDROP,       NP,           YC(260),
     8          HC,           LOUT,         NPRNT1,       YOUT(260,6),
     9          HI,           LV,           NSIN,         YR(260)
      COMMON/CZ/HR(260),      MAJOR,        NSYS,         Z(260,10),
     1          IDKIN(20),    MINOR,        NT,
     2          IDKINC(20),   MPD,          OUT(20,6),    IPART,
     3          IDSIN(260),   MPDP,         PC,
     4          IEV(11),      NAMX1(260),   R,          IEVN(11)
      DIMENSION NORDER(23),MORDER(24)
      DO 5 I=1,LB
      NORDER(I)=I
    5 MORDER(I)=I
      DO 50 L=1,LV
      DIVB=0.0
      DO 10 I=L,LV
      IN=NORDER(I)
      DO 10 J=L,LV
      JN=MORDER(J)
      IF(ABS(DIVB).GT.ABS(EL(IN,JN))) GO TO 10
      DIVB=EL(IN,JN)
      IT=IN
      JT=JN
      IFROM=I
      JFROM=J
   10 CONTINUE
      NORDER(IFROM)=NORDER(L)
      NORDER(L)=IT
      MORDER(JFROM)=MORDER(L)
      MORDER(L)=JT
   35 DO 40 J=L,LB
      JN=MORDER(J)
      IF(DIVB.EQ.0.0)DIVB=1.0
   40 EL(IT,JN)=EL(IT,JN)/DIVB
      IF(L.GE.LV) GO TO 55
      MN=L+1
      DO 50 I=MN,LV
      IN=NORDER(I)
      FMULT=EL(IN,JT)
      DO 50 J=MN,LB
      JN=MORDER(J)
   50 EL(IN,JN)=EL(IN,JN)-EL(IT,JN)*FMULT
   55 I=LV
      SIGMA=0.0
   60 IN=NORDER(I)
      JN=MORDER(I)
      ANS(JN)=EL(IN,LB)-SIGMA
      IF(I.LE.1) GO TO 70
      IN=NORDER(I-1)
      SIGMA=0.0
      DO 65 J=I,LV
      JN=MORDER(J)
   65 SIGMA=SIGMA+EL(IN,JN)*ANS(JN)
      I=I-1
      GO TO 60
   70 CONTINUE
      RETURN
      END
