(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      9652,        268]
NotebookOptionsPosition[      8201,        235]
NotebookOutlinePosition[      8624,        252]
CellTagsIndexPosition[      8581,        249]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ",", "x", ",", "k", ",", 
   " ", 
   RowBox[{"FourierParameters", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9376459362971897`*^9, 3.937645993868403*^9}, {
  3.937646036823038*^9, 3.9376460449279423`*^9}, {3.9376461042563066`*^9, 
  3.9376461228655643`*^9}, {3.937646241077035*^9, 3.93764624120996*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"ed6d22e2-ff3a-47aa-a569-9eb08d3b3362"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["c", "2"]}], " ", 
  SuperscriptBox["k", "2"], " ", 
  RowBox[{"FourierTransform", "[", 
   RowBox[{
    RowBox[{"u", "[", "x", "]"}], ",", "x", ",", "k"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.93764599464109*^9, {3.93764603861771*^9, 3.937646045698327*^9}, 
   3.937646250186014*^9, 3.937789425271614*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"72d39d04-04b0-4a39-8ab7-87dd0f94f51a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"A", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"\[ImaginaryI]", " ", "c", " ", "k", " ", "t"}], "]"}]}], ",", 
   "k", ",", "x", ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"B", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "c", " ", "k", " ", "t"}], "]"}]}],
    ",", "k", ",", "x", ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"c", " ", "k", " ", "t"}], "]"}], ",", "k", ",", "x", ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.937646060670887*^9, 3.937646088055881*^9}, {
  3.93764625372371*^9, 3.9376462614870853`*^9}, {3.937646294086299*^9, 
  3.937646301178021*^9}, {3.937646357384644*^9, 3.937646364413866*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"483c761e-b23d-4b3d-afea-86776f6ed6aa"],

Cell[BoxData[
 RowBox[{"A", " ", 
  RowBox[{"DiracDelta", "[", 
   RowBox[{
    RowBox[{"c", " ", "t"}], "+", "x"}], "]"}]}]], "Output",
 CellChangeTimes->{3.937646088869193*^9, 3.937646261812044*^9, 
  3.93764630166748*^9, 3.937646364855721*^9, 3.937789427002645*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"330cc9b8-e1a7-46d8-b47d-d9ba8240b1f7"],

Cell[BoxData[
 RowBox[{"B", " ", 
  RowBox[{"DiracDelta", "[", 
   RowBox[{
    RowBox[{"c", " ", "t"}], "-", "x"}], "]"}]}]], "Output",
 CellChangeTimes->{3.937646088869193*^9, 3.937646261812044*^9, 
  3.93764630166748*^9, 3.937646364855721*^9, 3.937789427004053*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"0d89be50-5661-4c68-8910-3bf4751f674d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{
     RowBox[{"c", " ", "t"}], "-", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{
     RowBox[{"c", " ", "t"}], "+", "x"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.937646088869193*^9, 3.937646261812044*^9, 
  3.93764630166748*^9, 3.937646364855721*^9, 3.937789427017394*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"ab2ef939-25d2-4882-ac5d-3951c6e572da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"k0", " ", "x"}], " ", "-", " ", 
        RowBox[{"w", " ", "t"}]}], ")"}]}], "]"}]}], ",", "x", ",", "k", ",", 
   
   RowBox[{"FourierParameters", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"2", "\[Pi]", " ", "a", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "w", " ", "t"}], "]"}], " ", 
    RowBox[{"DiracDelta", "[", 
     RowBox[{"k", "-", "k0"}], "]"}]}], ",", "k", ",", "x", ",", 
   RowBox[{"FourierParameters", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.937789316510871*^9, 3.937789345633274*^9}, {
   3.937789375954941*^9, 3.93778941991185*^9}, {3.937789452093483*^9, 
   3.937789460016782*^9}, 3.937789555683284*^9, {3.937789859330851*^9, 
   3.9377899025998173`*^9}, {3.937790190013773*^9, 3.9377902165040417`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"2956927f-1499-45e8-b939-7e1beeb7833f"],

Cell[BoxData[
 RowBox[{"2", " ", "a", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "w"}]], " ", "\[Pi]", " ", 
  
  RowBox[{"DiracDelta", "[", 
   RowBox[{
    RowBox[{"-", "k"}], "+", "k0"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.9377893473048067`*^9, {3.937789386483138*^9, 3.937789460664319*^9}, 
   3.937789556231139*^9, 3.937789903239284*^9, {3.937790192836171*^9, 
   3.937790217404694*^9}},
 CellLabel->"Out[39]=",ExpressionUUID->"cb4a36b3-ec8a-47df-8326-59606899be53"],

Cell[BoxData[
 RowBox[{"a", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "w"}], "+", 
    RowBox[{"\[ImaginaryI]", " ", "k0", " ", "x"}]}]]}]], "Output",
 CellChangeTimes->{
  3.9377893473048067`*^9, {3.937789386483138*^9, 3.937789460664319*^9}, 
   3.937789556231139*^9, 3.937789903239284*^9, {3.937790192836171*^9, 
   3.937790217405897*^9}},
 CellLabel->"Out[40]=",ExpressionUUID->"52fdee64-6585-40f7-b7b0-6e0b91c832dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"FourierTransform", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
          RowBox[{"2", "\[Pi]"}], ")"}]}], "\[Sigma]"}]], 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox["x", "2"], 
         RowBox[{"2", 
          SuperscriptBox["\[Sigma]", "2"]}]]}], "]"}]}], ",", "x", ",", "k", 
     ",", 
     RowBox[{"FourierParameters", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Sigma]", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.937791052865046*^9, 3.937791174719685*^9}, {
  3.9377914969912033`*^9, 3.937791506825982*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"c15276a7-f215-48cf-9394-98afbb28d3bb"],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   SuperscriptBox["k", "2"], " ", 
   SuperscriptBox["\[Sigma]", "2"]}]]], "Output",
 CellChangeTimes->{{3.937791107714258*^9, 3.937791127278524*^9}, {
  3.937791161333939*^9, 3.937791175482616*^9}, {3.937791501095286*^9, 
  3.93779150753365*^9}},
 CellLabel->"Out[47]=",ExpressionUUID->"28564e36-f5e8-4aa0-a19f-494356dfed02"]
}, Open  ]]
},
WindowSize->{1680, 1837},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"704bc5d4-c26b-4f2d-9db9-a0d7069dac70"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 729, 18, 49, "Input",ExpressionUUID->"ed6d22e2-ff3a-47aa-a569-9eb08d3b3362"],
Cell[1312, 42, 450, 11, 52, "Output",ExpressionUUID->"72d39d04-04b0-4a39-8ab7-87dd0f94f51a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1799, 58, 1332, 33, 109, "Input",ExpressionUUID->"483c761e-b23d-4b3d-afea-86776f6ed6aa"],
Cell[3134, 93, 347, 7, 52, "Output",ExpressionUUID->"330cc9b8-e1a7-46d8-b47d-d9ba8240b1f7"],
Cell[3484, 102, 347, 7, 52, "Output",ExpressionUUID->"0d89be50-5661-4c68-8910-3bf4751f674d"],
Cell[3834, 111, 573, 14, 68, "Output",ExpressionUUID->"ab2ef939-25d2-4882-ac5d-3951c6e572da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4444, 130, 1291, 31, 78, "Input",ExpressionUUID->"2956927f-1499-45e8-b939-7e1beeb7833f"],
Cell[5738, 163, 543, 13, 52, "Output",ExpressionUUID->"cb4a36b3-ec8a-47df-8326-59606899be53"],
Cell[6284, 178, 498, 11, 52, "Output",ExpressionUUID->"52fdee64-6585-40f7-b7b0-6e0b91c832dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6819, 194, 924, 26, 79, "Input",ExpressionUUID->"c15276a7-f215-48cf-9394-98afbb28d3bb"],
Cell[7746, 222, 439, 10, 59, "Output",ExpressionUUID->"28564e36-f5e8-4aa0-a19f-494356dfed02"]
}, Open  ]]
}
]
*)

