(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      7243,        203]
NotebookOptionsPosition[      6291,        177]
NotebookOutlinePosition[      6719,        194]
CellTagsIndexPosition[      6676,        191]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"n", ",", "c"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["2", "n"], 
      RowBox[{"Factorial", "[", "n", "]"}], 
      SuperscriptBox["\[Pi]", 
       RowBox[{"1", "/", "2"}]]}], ")"}], 
    RowBox[{
     RowBox[{"-", "1"}], "/", "2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"c_", ",", "n_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"c", " ", 
   RowBox[{"Exp", "[", 
    FractionBox[
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "2"], "]"}], 
   RowBox[{"HermiteH", "[", 
    RowBox[{"n", ",", "x"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"\[Psi]", "[", 
     RowBox[{"c", ",", "n", ",", "x"}], "]"}], "2"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.93820585973402*^9, 3.9382058620003567`*^9}, {
  3.9382058960263023`*^9, 3.938205988961171*^9}, {3.938206102629628*^9, 
  3.9382061363223248`*^9}, {3.938206187494693*^9, 3.938206366925106*^9}, {
  3.938206482247963*^9, 3.938206496405541*^9}, {3.938207997091427*^9, 
  3.9382079988893747`*^9}, {3.938209459381748*^9, 3.938209464749029*^9}},
 CellLabel->
  "In[763]:=",ExpressionUUID->"62674114-9530-4364-8a66-46d846e48041"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{{3.9382059564360037`*^9, 3.938205989383718*^9}, {
   3.938206114974327*^9, 3.938206136816474*^9}, {3.9382061931453133`*^9, 
   3.938206301396287*^9}, {3.938206357473873*^9, 3.938206367535759*^9}, 
   3.938206497156292*^9, 3.9382080575843773`*^9, 3.9382094657503157`*^9},
 CellLabel->
  "Out[767]=",ExpressionUUID->"98bff65e-767f-482b-9db7-a1287ef1ea56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"n", ",", "c", ",", "a"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["2", "n"], 
      FractionBox[
       SuperscriptBox[
        RowBox[{"Factorial", "[", 
         FractionBox["n", "2"], "]"}], "2"], 
       RowBox[{"Factorial", "[", "n", "]"}]], 
      RowBox[{"(", 
       SuperscriptBox["\[Pi]", 
        RowBox[{"1", "/", "2"}]], ")"}]}], ")"}], 
    RowBox[{
     RowBox[{"-", "1"}], "/", "2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Y", "[", 
   RowBox[{"c_", ",", "n_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"c", " ", 
   RowBox[{"Exp", "[", 
    FractionBox[
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "2"], "]"}], 
   RowBox[{"Hypergeometric1F1", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"-", "n"}], "2"], ",", 
     FractionBox["1", "2"], ",", 
     SuperscriptBox["x", "2"]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Y", "[", 
     RowBox[{"c", ",", "n", ",", "x"}], "]"}], "2"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9382064124380074`*^9, 3.938206637743924*^9}, {
   3.9382067297767572`*^9, 3.9382067346321707`*^9}, {3.938206782527131*^9, 
   3.938206900170176*^9}, 3.9382069775542297`*^9, {3.9382076112285147`*^9, 
   3.938207621000115*^9}, {3.9382077454069843`*^9, 3.9382077599730253`*^9}, {
   3.938207834542076*^9, 3.938207930299323*^9}, {3.938208003223774*^9, 
   3.938208271259153*^9}, {3.938208365171568*^9, 3.938208391616514*^9}, 
   3.938208464645928*^9, {3.938208501791552*^9, 3.9382085019836903`*^9}, {
   3.93820856169519*^9, 3.938208563508112*^9}, {3.938208687791422*^9, 
   3.938208737954352*^9}, {3.938208870263566*^9, 3.938208888303727*^9}, {
   3.9382089655472107`*^9, 3.9382089688525047`*^9}, {3.938209469638756*^9, 
   3.9382094753069267`*^9}},
 CellLabel->
  "In[768]:=",ExpressionUUID->"9ec42f7a-88c5-493e-8ff6-71a92d36709b"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{{3.9382064989499207`*^9, 3.9382066383117723`*^9}, {
   3.938206731060746*^9, 3.938206735093253*^9}, {3.9382067831152487`*^9, 
   3.93820690117566*^9}, 3.938206978197896*^9, {3.938207752129506*^9, 
   3.93820776052429*^9}, {3.938207853342216*^9, 3.9382079308212423`*^9}, {
   3.938208009271213*^9, 3.9382082719991207`*^9}, {3.938208367372098*^9, 
   3.938208392006188*^9}, 3.938208466110241*^9, 3.938208502584197*^9, 
   3.9382085641831093`*^9, {3.938208689840119*^9, 3.938208704612329*^9}, 
   3.9382087394012127`*^9, {3.9382088743328342`*^9, 3.9382088888928347`*^9}, {
   3.938208966640851*^9, 3.938208969807797*^9}, 3.93820947640687*^9},
 CellLabel->
  "Out[772]=",ExpressionUUID->"08ee2b5f-8cd9-41f5-bb1c-6903b6051476"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SuperscriptBox["2", "m"], 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Factorial", "[", 
      FractionBox["m", "2"], "]"}], "2"], 
    RowBox[{"Factorial", "[", "m", "]"}]]}], "]"}]], "Input",
 CellChangeTimes->{{3.9383828837006893`*^9, 3.938382898450844*^9}},
 CellLabel->
  "In[773]:=",ExpressionUUID->"cf5d0812-f994-410f-9494-13f1d9f6bf42"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["m", "2"], "!"}], ")"}], "2"]}], 
  RowBox[{"m", "!"}]]], "Output",
 CellChangeTimes->{3.938382900000791*^9},
 CellLabel->
  "Out[773]=",ExpressionUUID->"305be6e6-e501-49d2-b93a-cef848f69e20"]
}, Open  ]]
},
WindowSize->{1319, 1050},
WindowMargins->{{521, Automatic}, {Automatic, 307}},
Magnification:>1.25 Inherited,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"df3b1068-9788-4b9c-9f7f-090366e11ef1"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 1511, 41, 174, "Input",ExpressionUUID->"62674114-9530-4364-8a66-46d846e48041"],
Cell[2094, 65, 401, 6, 42, "Output",ExpressionUUID->"98bff65e-767f-482b-9db7-a1287ef1ea56"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2532, 76, 2190, 56, 219, "Input",ExpressionUUID->"9ec42f7a-88c5-493e-8ff6-71a92d36709b"],
Cell[4725, 134, 770, 11, 42, "Output",ExpressionUUID->"08ee2b5f-8cd9-41f5-bb1c-6903b6051476"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5532, 150, 405, 11, 69, "Input",ExpressionUUID->"cf5d0812-f994-410f-9494-13f1d9f6bf42"],
Cell[5940, 163, 335, 11, 69, "Output",ExpressionUUID->"305be6e6-e501-49d2-b93a-cef848f69e20"]
}, Open  ]]
}
]
*)

